/**
 * Created by rockyl on 2019-12-10.
 */

export const queryParams: any = {};

let search = window.location.search;
try {
	search = top.location.search;  //尝试获取顶层的链接
} catch (e) { /* empty */ }

for (const item of search.replace('?', '').split('&')) {
	const arr = item.split('=');
	queryParams[arr[0]] = arr.length === 1 ? true : decodeURIComponent(arr[1]);
}

export function windowVisibility(callback?: (visible: boolean) => void) {
//设置隐藏属性和改变可见属性的事件的名称
	let visibilityChange;
	if (typeof document.hidden !== 'undefined') {
		visibilityChange = 'visibilitychange';
	} else if (typeof document['msHidden'] !== 'undefined') {
		visibilityChange = 'msvisibilitychange';
	} else if (typeof document['webkitHidden'] !== 'undefined') {
		visibilityChange = 'webkitvisibilitychange';
	}

	const handleVisibilityChange = (e) => {
		callback && callback(document.visibilityState == "visible");
	};

	document.addEventListener(
		visibilityChange,
		handleVisibilityChange,
		false
	);
}
