import React, { HTMLAttributes, ReactElement, useState } from "react";


type MergedHTMLAttributes = Omit<
    HTMLAttributes<HTMLDivElement>,
    'onPause'
>;

interface IButtonProps extends MergedHTMLAttributes {
  anchorX?: "center" | "left" | "right";
  anchorY?: "center" | "top" | "bottom";
}


/**
 * @return ReactElement
 * @constructor
 * @param props
 */
export const Button = (props: IButtonProps): ReactElement => {

  const {
    children,
    className,
    style,
    onTouchStart,
    onTouchEnd,
    onTouchCancel,
    anchorX = "center",
    anchorY = "center",
  } = props;

  const [scale, setScale] = useState("unset");

  const touchStart = (e: React.TouchEvent<HTMLDivElement>) => {
    onTouchStart && onTouchStart(e);
    setScale("scale(0.92, 0.92)");
  };

  const touchEnd = (e: React.TouchEvent<HTMLDivElement>) => {
    onTouchEnd && onTouchEnd(e);
    setScale("unset");
  };

  const touchCancel = (e: React.TouchEvent<HTMLDivElement>) => {
    onTouchCancel && onTouchCancel(e);
    setScale("unset");
  }

  return <div
      {...props}
      className={className}
      onTouchStart={touchStart}
      onTouchEnd={touchEnd}
      onTouchCancel={touchCancel}
      style={{
        transitionDuration: "50ms",
        transform: scale,
        transformOrigin: `${anchorX} ${anchorY}`,
        ...style,
      }}
  >
    {children}
  </div>;
};
