const version = 'v1'

// Xingmalabconfirmpop 组件配置
export const xingmalabConfirmConfig = {
  // 图片资源路径配置
  images: {
    // 弹窗背景图片
    background: `XingmaLabPop/${version}/XingmaLabConfirmPopBg.png`,
    
    // 确认按钮图片
    confirmBtn: `XingmaLabPop/${version}/XingmaLabConfirmPopConfirmBtn.png`,
    
    // 取消按钮图片
    cancelBtn: `XingmaLabPop/${version}/XingmaLabCancelBtn.png`
  },

  // 弹窗尺寸配置
  dimensions: {
    width: 750,
    height: 1624,
    background: {
      width: 618,
      height: 557,
      image: `XingmaLabPop/${version}/XingmaLabConfirmPopBg.png`
    },
    confirmBtn: {
      width: 275,
      height: 97,
      left: 318,
      top: 408,
      image: `XingmaLabPop/${version}/XingmaLabConfirmPopConfirmBtn.png`
    },
    cancelBtn: {
      width: 279,
      height: 101,
      left: 28,
      top: 406,
      image: `XingmaLabPop/${version}/XingmaLabCancelBtn.png`
    }
  },

  // 文案配置
  texts: {
    defaultTitle: '确认',
    defaultConfirmText: '确认',
    defaultCancelText: '取消'
  },

  // 样式配置
  styles: {
    zIndex: 999,
    borderRadius: '16rpx',
    transition: 'all 0.3s ease'
  }
}

// Xingmalabnotimepop 组件配置
export const xingmalabNoTimeConfig = {
  // 图片资源路径配置
  images: {
    // 弹窗背景图片
    background: `XingmaLabPop/${version}/XingmaLabNoTimePopBg.png`,
    
    // 按钮图片
    button: `XingmaLabPop/${version}/XingmaLabNoTimePopBtn.png`
  },

  // 弹窗尺寸配置
  dimensions: {
    width: 750,
    height: 1624,
    background: {
      width: 618,
      height: 460,
      image: `XingmaLabPop/${version}/XingmaLabNoTimePopBg.png`
    },
    button: {
      width: 466,
      height: 97,
      left: 76,
      top: 312,
      image: `XingmaLabPop/${version}/XingmaLabNoTimePopBtn.png`
    }
  },

  // 文案配置
  texts: {
    defaultTitle: '暂无时间'
  },

  // 样式配置
  styles: {
    zIndex: 999,
    borderRadius: '16rpx',
    transition: 'all 0.3s ease'
  }
}

// 获取完整图片URL
export const getImageUrl = (imagePath) => {
  return `${imagePath}`
}

// 获取所有图片配置
export const getAllImages = () => {
  return {
    confirm: xingmalabConfirmConfig.images,
    noTime: xingmalabNoTimeConfig.images
  }
}

// 获取尺寸配置
export const getDimensions = (type = 'confirm') => {
  return type === 'noTime' ? xingmalabNoTimeConfig.dimensions : xingmalabConfirmConfig.dimensions
}

// 获取样式配置
export const getStyles = (type = 'confirm') => {
  return type === 'noTime' ? xingmalabNoTimeConfig.styles : xingmalabConfirmConfig.styles
}

// 获取指定组件的配置
export const getComponentConfig = (type = 'confirm') => {
  return type === 'noTime' ? xingmalabNoTimeConfig : xingmalabConfirmConfig
}

// 获取指定组件的图片配置
export const getComponentImages = (type = 'confirm') => {
  return type === 'noTime' ? xingmalabNoTimeConfig.images : xingmalabConfirmConfig.images
}

// 获取指定组件的完整图片URL
export const getComponentImageUrl = (type = 'confirm', imageKey) => {
  const images = getComponentImages(type)
  return images[imageKey] ? `${getImageUrl(images[imageKey])}` : ''
}

// 获取指定组件的所有图片URL
export const getAllComponentImageUrls = (type = 'confirm') => {
  const images = getComponentImages(type)
  const result = {}
  Object.keys(images).forEach(key => {
    result[key] = getComponentImageUrl(type, key)
  })
  return result
}
