import requestModule from './request.js';
const {
    api
} = requestModule;


/**
 * 获取商品详情
 * @param {gid} data 
 * @returns 
 */
export const fetchGoodsDetail = (data) => api.get('/c/goods/detail', data);




/**
 * 计算商品价格优惠
 * @param {Object} data - 请求参数
 * @param {number} data.gid - 商品ID (必须)
 * @param {number} [data.skuld] - 商品规格ID (可选)
 * @param {number} [data.buy_num=1] - 下单数量 (可选，默认1)
 * @param {string} [data.phone] - 充值号码 (可选)
 * @param {string} [data.amount] - 充值面额 (可选)
 * @param {number} [data.couponId] - 优惠券ID (可选)
 * @param {string} [data.remark] - 下单备注 (可选)
 * @param {number} [data.addressId] - 地址ID (可选)
 * @param {number} [data.storeId] - 门店ID (可选)
 * @param {string} [data.projectId] - 活动ID (可选)
 * @returns {Promise} API响应
 * @description 计算商品价格和优惠信息，在下单前调用
 */
export const fetchGoodsPrice = (data) => api.get('/c/goods/price', data);

/**
 * 下单
 * @param {Object} data - 请求参数
 * @param {number} data.gid - 商品ID (必须)
 * @param {number} [data.skuld] - 商品规格ID (可选)
 * @param {number} [data.buy_num=1] - 下单数量 (可选，默认1)
 * @param {string} [data.phone] - 充值号码 (可选)
 * @param {string} [data.amount] - 充值面额 (可选)
 * @param {number} [data.couponId] - 优惠券ID (可选)
 * @param {string} [data.remark] - 下单备注 (可选)
 * @param {number} [data.addressId] - 地址ID (可选)
 * @param {number} [data.storeId] - 门店ID (可选)
 * @param {string} [data.projectId] - 活动ID (可选)
 * @returns {Promise} API响应
 * @description 创建订单，在价格计算后调用
 */
export const fetchTradeCredits = (data) => api.get('/c/trade/credits', data);





