import { defineStore } from "pinia";
import { myObj } from "../mock/my";
import { fetchUserJSON } from "@/api/user";

export const usePageCfgStore = defineStore("pageCfg", {
  state: () => {
    return {
      toolList: [],
      wheelOptionsYL: [],
      wheelOptionsYZ: [],
      contentCfg: {
        contentLikeOptions: [],
        productLikeOptions: [],
        specialAttentionOptions: [],
        channelOptions: [],
      },
    };
  },
  actions: {
    async fetchCfg() {
      const { data } = await fetchUserJSON();

      if (!data) return;

      this.toolList = data?.tool?.[0] || [];
      this.contentCfg = data.contentCfg;
      this.wheelOptionsYL = data.wheelOptionsYL;
      this.wheelOptionsYZ = data.wheelOptionsYZ;
    },
  },
});
