import { defineStore } from "pinia";
import {
    assessmentSave,
    getGrowthCurveData
} from "../api/shengzhangTools.js";

export const useShengzhangStore = defineStore("shengzhangInfo", {
  state: () => {
    return {
      shengzhangInfo: null,
      getGrowthCurveDataInfoHeight: null,
      getGrowthCurveDataInfoWeight: null,
      getGrowthCurveDataInfoHead: null,
      getGrowthCurveDataInfoBmi: null,
    };
  },
  actions: {
    /**
     * 设置生长测评结果
     * @param {Object} userInfo
     */
    setShengzhangInfo(shengzhangInfo) {
      this.shengzhangInfo = shengzhangInfo;
    },

    async assessmentSave(submitData) {

      const data = await assessmentSave(submitData);
      if(data.success){
        data.data.success = data.success;
        this.setShengzhangInfo(data.data);
      }
    },

    setGetGrowthCurveDataHeightInfo(getGrowthCurveDataInfo) {
      this.getGrowthCurveDataInfoHeight = getGrowthCurveDataInfo;
    },

    setGetGrowthCurveDataWeightInfo(getGrowthCurveDataInfo) {
      this.getGrowthCurveDataInfoWeight = getGrowthCurveDataInfo;
    },

    setGetGrowthCurveDataHeadInfo(getGrowthCurveDataInfo) {
      this.getGrowthCurveDataInfoHead = getGrowthCurveDataInfo;
    },

    setGetGrowthCurveDataBmiInfo(getGrowthCurveDataInfo) {
      this.getGrowthCurveDataInfoBmi = getGrowthCurveDataInfo;
    },

    async getGrowthCurveData(babyData) {
      const data = await getGrowthCurveData(babyData);
      if(data.success){
        data.data.success = data.success;

        switch(babyData.curveType){
          case 'HEIGHT':
            this.setGetGrowthCurveDataHeightInfo(data.data);
            break;
          case 'WEIGHT':
            this.setGetGrowthCurveDataWeightInfo(data.data);  
            break;
          case 'HEAD':
            this.setGetGrowthCurveDataHeadInfo(data.data);
            break;
          case 'BMI':
            this.setGetGrowthCurveDataBmiInfo(data.data);
            break;
        }
      }
    },

  },
});
