import {
	defineStore
} from 'pinia';

const cuk = uni.getStorageSync('cuk')

export const useGlobalStore = defineStore('global', {
	state: () => {
		return {
			cuk: cuk, // 用户登录后获取的凭证，调用接口时headers中携带
			curTabIndex: 0, // 当前Tab索引
			isWxFriendCircle:false
		};
	},
	actions: {
		/**
		 * 设置用户cuk
		 * @param {Object} cuk
		 */
		setCuk(cuk) {
			this.cuk = cuk;
			uni.setStorageSync('cuk', cuk);
		},
		/**
		 * 设置当前Tab索引
		 * @param {number} index
		 */
		setCurTabIndex(index) {
			this.curTabIndex = index;
		},
		
		/**
		 * 设置当前是否是小程序朋友圈单页环境
		 * @param {boolean} v
		 */
		setIsWxFriendCircle(v){
			this.isWxFriendCircle = v
		}
		
	},
});