import {
	defineStore
} from 'pinia';

const cuk = uni.getStorageSync('cuk')

export const useGlobalStore = defineStore('global', {
	state: () => {
		return {
			cuk: cuk, // 用户登录后获取的凭证，调用接口时headers中携带
			curTabIndex: 0, // 当前Tab索引
		};
	},
	actions: {
		/**
		 * 设置用户cuk
		 * @param {Object} cuk
		 */
		setCuk(cuk) {
			this.cuk = cuk;
			uni.setStorageSync('cuk', cuk);
		},
		/**
		 * 设置当前Tab索引
		 * @param {number} index
		 */
		setCurTabIndex(index) {
			this.curTabIndex = index;
		}
	},
});