# 飞鹤星妈会小程序项目

## 项目简介

飞鹤星妈会小程序是专为母婴用户打造的一站式育儿服务平台，提供专业的育儿知识、实用的育儿工具以及活跃的社区交流功能，助力妈妈们科学育儿，陪伴宝宝健康成长。

## 技术栈

- **前端框架**：uni-app（Vue 2/Vue 3）
- **状态管理**：Pinia
- **UI组件库**：Vant Weapp
- **构建工具**：HBuilderX/uni-app CLI

## 快速开始

### 环境要求

- Node.js >= 12.0.0
- npm >= 6.0.0
- HBuilderX（推荐）或VSCode
- 微信开发者工具

### 安装依赖

```bash
npm install
```

### 开发调试

1. 在HBuilderX中打开项目
2. 选择运行 -> 运行到小程序模拟器 -> 微信开发者工具

或使用命令行：

```bash
# 开发模式
npm run dev:mp-weixin

# 构建生产版本
npm run build:mp-weixin
```

### 目录说明

项目采用标准的uni-app目录结构，主要包含以下部分：

- `api/`：API接口定义和请求封装
- `components/`：自定义组件
- `pages/`：小程序页面
- `stores/`：Pinia状态管理
- `utils/`：工具函数
- `views/`：主要视图组件
- `mock/`：模拟数据

详细的项目结构说明请参考[project_structure.md](project_structure.md)文件。

## 核心功能

1. **用户中心**：登录授权、信息管理、宝宝档案
2. **育儿工具**：喂养记录、产检提醒、生长测评、星妈起名
3. **内容中心**：育儿知识、专家问答、社区分享
4. **品牌服务**：产品信息、会员权益、活动参与

## 开发规范

1. **代码规范**：遵循Vue.js风格指南
2. **命名规范**：采用语义化命名，组件使用大驼峰，文件使用小写字母加连字符
3. **API调用**：统一使用api目录下的封装方法
4. **状态管理**：全局状态使用Pinia，组件状态使用data或ref/reactive
5. **页面跳转**：统一使用utils中的jump方法

## 注意事项

1. 项目同时支持Vue 2和Vue 3，开发时注意版本差异
2. 开发前请确保已阅读[project_structure.md](project_structure.md)文档
3. 所有接口调用需要在用户登录后进行
4. 提交代码前请确保代码能正常编译和运行
5. 敏感信息（如API密钥、用户凭证）请勿直接硬编码在代码中

## 联系方式

如有任何问题或建议，请联系项目负责人。

---
