export enum JumpType {
	INNER = 1, // 内部小程序页面跳转
	MINI = 2, // 其他小程序页面跳转
	H5 = 3, // https 网络连接跳转
}

export interface LinkType {
	type: JumpType
	url: string
	extra?: Record<string, any>
}

export interface MdConfig {
	pageName: string
	componentName: string
	componentContent: string
	logExposure?: boolean
	logClick?: boolean
}

export interface CodeResponse<T> {
	code: number
	message: string
	data: T
	success: boolean
	ok: boolean
}

export interface Prize{
	prizeName: string
	prizeImageUrl: string
}

export interface ActivityInfo {
	invitationCode: string
	invitationText: string
	invitationImageUrl: string
	invitedCount: number
	nextRewardNeedCount: number
	unclaimedPrizes: Prize[]
	receivedPrizes: Prize[]
}
