import {
	defineStore
} from 'pinia';
import {
	fetchHomeInfo
} from '../api/home.js';



export const useHomeStore = defineStore('homeInfo', {
	state: () => {
		return {
			homeInfo: null,
			isLogin:false,
			babyExistence:false
		};
	},
	actions: {
		/**
		 * 更新首页信息
		 * @param {Object} homeInfo
		 */
		setHomeInfo(homeInfo) {
			this.homeInfo = homeInfo;
			if(homeInfo?.memberId === "not_login"){
				this.isLogin = false;
			}else{
				this.isLogin = true;
			}
		},
		setBabyExistence(babyExistence){
			console.log('setBabyExistence', babyExistence);
			this.babyExistence = !babyExistence;
		},

		/**
		 * 获取首页信息
		 */
		async loadHomeInfo() {
			const {
				data
			} = await fetchHomeInfo();
			console.log('loadHomeInfo', data);
			if(data){
				this.setHomeInfo(data);
			}
		},

		
	},
});