# 飞鹤星妈会项目框架文档

## 1. 项目概述

本项目是基于uni-app框架开发的飞鹤星妈会微信小程序，主要为母婴用户提供育儿知识、工具服务和社区互动功能。

## 2. 技术栈

- **前端框架**：Vue 2/Vue 3（支持双版本）
- **状态管理**：Pinia
- **UI组件库**：Vant Weapp
- **HTTP请求**：封装的uni.request
- **数据模拟**：Mock数据
- **构建工具**：uni-app CLI

## 3. 项目目录结构

```
├── api/                 # API接口定义和请求封装
├── assets/              # 静态资源文件
├── components/          # 自定义组件
├── mock/                # 模拟数据文件
├── pages/               # 小程序页面
├── stores/              # Pinia状态管理
├── utils/               # 工具函数
├── views/               # 主要视图组件
├── wxcomponents/        # 微信小程序原生组件
├── App.vue              # 应用入口文件
├── main.js              # 应用初始化
├── package.json         # 项目依赖
├── pages.json           # 页面配置
```

## 4. 核心模块介绍

### 4.1 入口与初始化（main.js）

- 支持Vue 2和Vue 3双版本
- 全局挂载基础URL和数据埋点sensors
- 初始化Pinia状态管理

```javascript
// Vue 3 初始化示例
import { createSSRApp } from "vue";
export function createApp() {
  const app = createSSRApp(App);
  app.use(Pinia.createPinia());
  app.config.globalProperties.$baseUrl = BASE_URL;
  app.config.globalProperties.$sensors = md.sensors;
  return { app, Pinia };
}
```

### 4.2 页面配置（pages.json）

- 定义所有小程序页面路径和样式配置
- 配置导航栏标题、背景色等
- 自定义页面导航样式

```json
{
  "pages": [
    {
      "path": "pages/index/index",
      "style": {
        "navigationBarTitleText": "首页",
        "navigationStyle": "custom"
      }
    }
    // ...更多页面配置
  ]
}
```

### 4.3 网络请求（api/request.js）

- 统一的HTTP请求封装
- 支持GET、POST等请求方法
- 请求头统一处理，携带用户凭证
- 响应拦截与错误处理

```javascript
const request = (options = {}) => {
  return new Promise((resolve, reject) => {
    uni.request({
      url: baseUrl + options.url || "",
      method: options.type || "GET",
      data: options.data || {},
      header: {
        ...options.header,
        cuk: cuk.value || undefined
      },
    }).then((data) => {
      // 响应处理逻辑
    }).catch((error) => {
      // 错误处理逻辑
    });
  });
};
```

### 4.4 状态管理（stores/）

使用Pinia进行状态管理，主要包括：
- **user.js**：用户信息、宝宝信息管理
- **global.js**：全局配置和状态
- **home.js**：首页相关状态
- **pageCfg.js**：页面配置状态

```javascript
// user.js示例
export const useUserStore = defineStore("userInfo", {
  state: () => {
    return {
      userInfo: null,
      babyInfo: null,
      memberInfo: null,
      // ...其他状态
    };
  },
  actions: {
    // 用户信息更新等方法
  }
});
```

### 4.5 工具函数（utils/）

提供常用工具函数，包括：
- **跳转方法**：支持内部页面、其他小程序和H5跳转
- **日期格式化**：格式化时间戳为日期字符串
- **防连点函数**：防止用户快速重复点击

```javascript
// 通用跳转方法示例
export function jump({ type, url, extra = {} }) {
  switch (type) {
    case JumpType.INNER: // 内部页面跳转
      uni.navigateTo({ url, ...extra });
      break;
    case JumpType.MINI: // 其他小程序跳转
      // 小程序跳转逻辑
      break;
    case JumpType.H5: // H5页面跳转
      // H5跳转逻辑
      break;
  }
}
```

## 5. 主要业务功能

### 5.1 首页（views/Home.vue）

- 轮播图展示
- 工具推荐
- 专家团展示
- 内容推荐
- 搜索入口

### 5.2 用户系统

- 微信登录授权
- 手机号绑定
- 用户信息管理
- 宝宝信息管理（支持多宝宝切换）

### 5.3 育儿工具

- 喂养记录（feedingIndex）
- 产检提醒（postnatalCheckUp）
- 宝宝生长测评（shengzhangTools）
- 星妈起名（naming）
- 星妈会Lab（内容创作与分享）

### 5.4 内容模块

- 内容库（library）
- 搜索功能（search）
- 详情页（多种类型）

## 6. 组件系统

### 6.1 自定义组件（components/）

- **CustomLoading.vue**：自定义加载组件，支持文字逐字显示
- **DatePicker.vue**：日期选择器
- **TabBar.vue**：标签栏
- **Layer.vue**：弹窗组件

### 6.2 Vant组件库（wxcomponents/vant/）

项目集成了Vant Weapp组件库，主要使用：
- Tab/Tabs：标签页组件
- Sticky：粘性布局
- Info：信息提示

## 7. Mock数据（mock/）

- 提供模拟数据用于开发和测试
- 包含首页、品牌、积分等模块的数据
- 支持快速开发和接口联调前的功能验证

## 8. 数据埋点

项目集成了sensors数据埋点，用于用户行为分析：
- 页面访问统计
- 按钮点击事件
- 功能使用情况

```javascript
md.init(SENSORS_URL);
// 在组件中使用
this.$sensors.track('event_name', { /* 事件属性 */ });
```

## 9. 开发规范

### 9.1 目录命名
- 采用小写字母和下划线组合
- 组件和页面使用大驼峰或连字符命名

### 9.2 API调用规范
- 所有API请求统一通过api目录下的模块调用
- 遵循Promise规范处理异步请求
- 错误处理统一在请求拦截器中处理

### 9.3 状态管理规范
- 组件内状态使用data或ref/reactive
- 全局状态和跨组件共享状态使用Pinia
- 遵循单向数据流原则

## 10. 注意事项

- 项目支持Vue 2和Vue 3，开发时注意版本差异
- 所有页面跳转使用utils中的jump方法，统一管理跳转逻辑
- 网络请求统一使用api/request.js中的封装方法
- 组件开发时注意复用性和性能优化
- 敏感信息（如用户凭证）需要安全存储和传输

## 11. 项目启动与构建

```bash
# 安装依赖
npm install

# 开发调试
npm run dev:mp-weixin

# 构建发布
npm run build:mp-weixin
```

## 12. 常见问题与解决方案

1. **页面跳转失败**：检查pages.json中是否注册页面，检查跳转类型是否正确
2. **数据请求失败**：检查请求参数格式，检查用户是否登录，检查网络连接
3. **组件样式问题**：检查样式覆盖和优先级，注意微信小程序的样式隔离机制
4. **性能优化**：避免不必要的渲染，使用分页加载，合理使用缓存

---

以上是项目的主要框架和结构说明，希望能帮助新成员快速熟悉项目。如有任何疑问，请随时咨询项目负责人或技术骨干。