# BabyClass 组件

## 概述

BabyClass 是一个 Vue 3 组件，用于显示不同等级的权益信息。该组件遵循 Vue 3 Composition API 规范，使用 `<script setup>` 语法糖。

## 特性

- 🎨 支持5个等级：Diamond、Starshine、Starlight、Gold、Platinum
- 🖼️ 使用 `image` 标签显示图片，支持 `mode="aspectFit"`
- 📱 响应式设计，使用 rpx 单位适配不同屏幕
- 🎯 图片资源统一管理，便于维护
- 🔧 遵循项目开发规范

## 文件结构

```
components/pointRightsCom/
├── babyClass.vue          # 主组件文件
├── babyClassImages.js     # 图片资源常量文件
└── README.md             # 说明文档
```

## 使用方法

### 1. 导入组件

```vue
<template>
  <BabyClass />
</template>

<script setup>
import BabyClass from '@/components/pointRightsCom/babyClass.vue'
</script>
```

### 2. 全局注册（可选）

在 `main.js` 中全局注册：

```javascript
import BabyClass from '@/components/pointRightsCom/babyClass.vue'

// Vue 2
Vue.component('BabyClass', BabyClass)

// Vue 3
app.component('BabyClass', BabyClass)
```

## 图片资源

所有图片资源都通过 `babyClassImages.js` 文件统一管理，使用 `$baseUrl` 全局变量构建完整路径。

### 支持的图片类型

- **背景图片**: 各等级的背景图片
- **标题图片**: 各等级的标题图片
- **权益图片**: 各等级的权益说明图片（4张）
- **按钮图片**: 各等级的操作按钮
- **描述图片**: 各等级的详细描述

## 样式说明

- 使用 Less 预处理器
- 支持 scoped 样式隔离
- 导入项目公共样式 `res.less`
- 使用 rpx 单位确保跨平台兼容性

## 技术栈

- Vue 3 Composition API
- `<script setup>` 语法糖
- uni-app 框架
- Less 样式预处理器

## 注意事项

1. 确保 `$baseUrl` 全局变量已正确配置
2. 图片资源路径需要与后端资源保持一致
3. 组件使用绝对定位布局，父容器需要设置相对定位
4. 支持 `modal_center` 类名用于居中显示

## 更新日志

### v1.0.0
- 初始版本
- 支持5个等级权益展示
- 图片资源统一管理
- Vue 3 Composition API 实现
