import { defineStore } from "pinia";
import { getSigninAndTaskInfoJSON, checkInJSON } from "../api/integral";
import signinAndTaskInfoMock from '../mock/getSigninAndTaskInMock.json';
import checkInMock from '../mock/checkIndata.json';
export const useIntegralStore = defineStore("integral", {
  state: () => {
    return {
      _signinAndTaskInfo: null,
      _checkInData: null, // 新增：存储签到数据
    };
  },
  actions: {
    async getSigninAndTaskInfo(isdebug = false) {
        if(isdebug) {
            this._signinAndTaskInfo = signinAndTaskInfoMock;
            return signinAndTaskInfoMock;
        }else{
            const res = await getSigninAndTaskInfoJSON();
            this._signinAndTaskInfo = res;
            return res;
        }
    },
    async checkIn(activityId,isdebug = false) {
        if(isdebug) {
            this._checkInData = checkInMock; // 存储到state中
            return checkInMock;
        }else{
            const res = await checkInJSON(activityId);
            

            this._checkInData = res; // 存储到state中
            return res;
        }
    },
  },
  getters: {
    signinAndTaskInfo : (state) =>    {return state._signinAndTaskInfo;   },  
    checkInData : (state) =>    {return state._checkInData;   },
  },
});