import sensors, {
  enableVue3MpClick,
} from "./js_sdk/Sensorsdata-UniPlugin-JS/index";


const init = (SENSORS_URL) => {
  sensors.setPara({
    name: "sensors",
    server_url: SENSORS_URL,
    show_log: true,
    autoTrack: {
      appLaunch: true, // 默认为 true，false 则关闭 $MPLaunch 事件采集
      appShow: true, // 默认为 true，false 则关闭 $MPShow 事件采集
      appHide: true, // 默认为 true，false 则关闭 $MPHide 事件采集
      pageShow: true, // 默认为 true，false 则关闭 $MPViewScreen 事件采集
      pageShare: true, // 默认为 true，false 则关闭 $MPShare 事件采集
      mpClick: true, // 默认为 false，true 则开启 $MPClick 事件采集
      mpFavorite: true, // 默认为 true，false 则关闭 $MPAddFavorites 事件采集
      pageLeave: true, // 默认为 false， true 则开启 $MPPageLeave事件采集
    },
  });

  enableVue3MpClick();

  // sensors.init();
};

const login = (ext) => {
  console.log("login", ext);
  sensors.register({
    miniName: "飞鹤星妈会",
    ...ext
  });
  sensors.login(ext.memberid);
};

export default {
  init,
  sensors,
  login
};
