import requestModule from './request.js'
const { api } = requestModule

/**
 * 星妈会藏馆
 * @returns
 */
export const fetchRecordList = (pageNum, pageSize) => api.get('/c/lab/record/list', {
  pageNum: pageNum,
  pageSize: pageSize
})

/**
 * 我的收藏
 * @returns
 */
export const fetchFavoriteList = (pageNum, pageSize) => api.get('/c/lab/favorite/list', {
  pageNum: pageNum,
  pageSize: pageSize
})

/**
 * 我的藏品
 * @returns
 */

export const fetchRecordMyrecords = (pageNum, pageSize) => api.get('/c/lab/record/myRecords', {
  pageNum: pageNum,
  pageSize: pageSize
})

export const fetchRecordIndex = () => api.get('/c/lab/home')

export const fetchRecordPublish = (data) => api.post('/c/lab/record/create', data)

export const fetchRecordDetail = (data) => api.get('/c/lab/record/detail', data)

export const fetchFavoriteAdd = (data) => api.get('/c/lab/favorite/add', data)

export const fetchFavoriteRemove = (data) => api.get('/c/lab/favorite/remove', data)

export const generateQRCode = (data) => api.post('/c/wechat/generateQRCode', data)