const hosts = [
	{value: 'https://guide-api.feihe.com', alias: '生产环境'},
	{value: 'https://guide-api-test.feihe.com', alias: 'test环境'},
	{value: 'https://guide-api-uat.feihe.com', alias: 'uat环境'},
]

const pages = [
	{value: '/mini/#/page/momHome/index', alias: '妈妈爱活动'},
	{value: '/mini/#/page/home/index?page_source=3', alias: '路演活动'},
]

const singleUrls = [
	{value: 'https://testmanage.boysup.cn/smart-age/index.html#/', alias: 'smart-age'},
]

const mpPage = '/pages/activity/index'

function joinUrlAndQs(url, qs) {
	return qs
		? url + (url.includes('?') ? (url.endsWith('?') ? '' : '&') : '?') + qs
		: url
}

for (const page of pages) {
	for (const host of hosts) {
		const url = joinUrlAndQs(mpPage, `needLogin=1&url=${encodeURIComponent(host.value + page.value)}`)
		console.log(`${page.alias}-${host.alias}: ${url}`)
	}
}

for (const item of singleUrls) {
	const url = joinUrlAndQs(mpPage, `needLogin=1&url=${encodeURIComponent(item.value)}`)
	console.log(`${item.alias}: ${url}`)
}
