import requestModule from "./request.js";
const { api } = requestModule;

/**
 * 通过此接口完成手机号授权，注册新用户
 * @param {*} data : {phoneEncryptedData, phoneIv, code, codeLogin}
 * @returns
 */
export const uploadImage = (file64) =>
  api.post(
    "/c/upload/image",
    {
      img64: file64,
    },
    {
      headers: {
        "Content-Type": "application/json",
      },
    }
  );

export const getHealthField = () => api.get("/c/user/getHealthField");
