// 产检提醒模块相关接口
import requestModule from './request.js';
const { api } = requestModule;

/**
 * 获取banner
 * @returns
 */

export const postnatalJSON = () => api.get('/c/front/content',{type:'postnatal'});

/**
 * 获取产检信息
 * @returns
 */

export const getInfo = (data) => api.get('/c/maternityCheckup/home',data);

/**
 * 产看产检详情
 * @returns
 */

export const getDetail = (data) => api.get('/c/maternityCheckup/detail',data);

/**
 * 删除报告单
 * @returns
 */

export const getDelete = (data) => api.get('/c/maternityCheckup/delete',data);

/**
 * 产检项目列表
 * @returns
 */

export const getExaminationItems = (data) => api.get('/c/maternityCheckup/examinationItems',data);

/**
 * 修改产检记录
 * @returns
 */

export const getUpdate = (data) => api.post('/c/maternityCheckup/update',data);

/**
 * 
 * /**
 * 新增产检记录
 * @returns
 */

export const getAdd = (data) => api.post('/c/maternityCheckup/add',data);

/**
 * 我的报告单列表
 * @returns
 */

export const getReportList = (data) => api.get('/c/maternityCheckup/reportList', data);

/**
 * 保存订阅消息
 * @returns
 */
export const getWxNotification = (data) => api.post('/c/wxNotification/save',data);

/**
 * 修改报告单
 * @returns
 */
export const getDeleteReportImg = (data) => api.post('/c/maternityCheckup/deleteReportImg',data);