import {
	defineStore
} from 'pinia';

const cuk = uni.getStorageSync('cuk')
const openId = uni.getStorageSync('openId')
const unionId = uni.getStorageSync('unionId')

export const useGlobalStore = defineStore('global', {
	state: () => {
		return {
			cuk: cuk, // 用户登录后获取的凭证，调用接口时headers中携带
			curTabIndex: 0, // 当前Tab索引
			isWxFriendCircle:false,
			isShowLoading: false,
			openId: openId,
			unionId: unionId,
			baseUrl: '',
			isShowInvitePrizePanel: false, // 是否显示邀请奖品弹窗
		};
	},
	actions: {
		setBaseUrl(url){
			this.baseUrl = url
		},
		/**
		 * 设置用户cuk
		 * @param {Object} cuk
		 */
		setCuk(cuk,openId,unionId) {
			this.cuk = cuk;
			this.openId = openId;
			this.unionId = unionId;
			uni.setStorageSync('openId', openId);
			uni.setStorageSync('unionId', unionId);
			uni.setStorageSync('cuk', cuk);
		},
		/**
		 * 设置当前Tab索引
		 * @param {number} index
		 */
		setCurTabIndex(index) {
			this.curTabIndex = index;
		},
		
		/**
		 * 设置当前是否是小程序朋友圈单页环境
		 * @param {boolean} v
		 */
		setIsWxFriendCircle(v){
			this.isWxFriendCircle = v
		},
		
		setIsShowLoading(v){
			this.isShowLoading = v
		}
	},
});