const version = 'v1'

// 星妈实验室发布页面配置
export const xingmaLabConfig = {

  // 图片资源路径配置
  images: {
    // 背景图片
    background: `XingmaLabPublishPage/${version}/XingmaLabPublishPageBg.png`,

    // 未选择状态图片
    noSel: {
      bottomConBg: `XingmaLabPublishPage/${version}/XingmaLabPublishPageNoSelBottomConBg.png`,
      bottomConBtn: `XingmaLabPublishPage/${version}/XingmaLabPublishPageNoSelBottomConBtn.png`,
      btn: `XingmaLabPublishPage/${version}/XingmaLabPublishPageNoSelBtn.png`
    },

    // 选择状态图片
    sel: {
      bottomConPublishBtnBg: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSelBottomConPublishBtnBg.png`,
      bottomConPublishBtn: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSelBottomConPublishBtn.png`,
      pic: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSelPic.png`,
      cpver: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSelCpver.png`,
      retry: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSelRetry.png`
    },

    // 成功状态图片
    suc: {
      bottomConIcon: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSucBottomConIcon.png`,
      bottomConBg: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSucBottomConBg.png`,
      bottomConBtn: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSucBottomConBtn.png`,
      picBg: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSucPicBg.png`,
      pic: `XingmaLabPublishPage/${version}/XingmaLabPublishPageSucPic.png`
    }
  },

  // 页面状态配置
  states: {
    NOSEL: 'nosel', // 未选择状态
    SEL: 'sel', // 选择状态
    SUC: 'suc' // 成功状态
  },

  // 文案配置
  texts: {
    noSel: {
      placeholder: '记录这个时刻……'
    },
    sel: {
      title: '快来用星妈会小程序'
    },
    suc: {
      numberPrefix: 'No.'
    }
  },

  // 发布成功文案配置
  successMessages: [
    '最好的礼物不是玩具，是陪宝贝长大的光阴。欢迎将宝贝的珍贵回忆，存入你的"时光银行"。',
    '时光会走远，影像能长存。星妈会，为您珍藏每一份稚的美好。',
    '孩子终将长大，但「星妈会Lab」会帮你永远记得宝贝现在的样子。',
    '孩子是我们写在时光里的诗，每一次记录，都是爱的注脚。',
    '照片是时间的化石，为易逝的童年建立不朽的纪念碑。',
    '有一天，孩子会离开我去闯荡世界。所以现在，我们要认真记录现在ta依恋我们的样子。',
    '父母与子女的缘分，就是不断目送他的背影渐行渐远。而照片，能让那背影在记忆中永不模糊。'
  ],

  // 图片上传配置
  upload: {
    maxSize: 10 * 1024 * 1024, // 10MB，待定
    maxSizeText: '照片太大啦，换一张试试吧～',
    maxWords: 1000,
    maxWordsText: '字数已达上限',
    allowedTypes: ['jpg', 'png', 'jpeg'],
    maxCount: 1
  }
}

// 获取完整图片URL
export const getImageUrl = (imagePath) => {
  return `${imagePath}`
}

// 获取状态对应的图片配置
export const getStateImages = (state) => {
  switch (state) {
    case xingmaLabConfig.states.NOSEL:
      return xingmaLabConfig.images.noSel
    case xingmaLabConfig.states.SEL:
      return xingmaLabConfig.images.sel
    case xingmaLabConfig.states.SUC:
      return xingmaLabConfig.images.suc
    default:
      return xingmaLabConfig.images.noSel
  }
}

// 获取随机成功文案
export const getRandomSuccessMessage = () => {
  const messages = xingmaLabConfig.successMessages
  const randomIndex = Math.floor(Math.random() * messages.length)
  return messages[randomIndex]
}
