# 星妈实验室发布页面 (XingmaLabPublishPage)

## 概述

这是一个基于Vue 3 Composition API开发的星妈实验室发布页面组件，用于展示不同状态下的页面内容和交互，支持图片上传、文案编辑、发布流程等功能。

## 功能特性

- **三种状态展示**：未选择状态、选择状态、成功状态
- **图片上传功能**：支持相机/相册选择，限制大小和格式
- **文案编辑功能**：支持纯文本输入，限制字数上限
- **发布流程管理**：包含微信授权、确认弹窗、发布成功等步骤
- **动态资源管理**：通过配置文件统一管理图片资源
- **响应式设计**：支持不同屏幕尺寸的适配
- **交互动画**：包含淡入动画和悬停效果
- **状态管理**：使用Vue 3的响应式系统管理页面状态

## 文件结构

```
XingmaLabPublishPage/
├── XingmaLabPublishPage.vue    # 主组件文件
├── XingmaLabPublishPage.less   # 样式文件
├── config.js                   # 配置文件
└── README.md                   # 说明文档
```

## 使用方法

### 1. 基本使用

```vue
<template>
  <XingmaLabPublishPage />
</template>

<script setup>
import XingmaLabPublishPage from '@/pages/XingmaLabPublishPage/XingmaLabPublishPage.vue'
</script>
```

### 2. 状态控制

组件内部管理三种状态：
- `nosel`: 未选择状态（默认）
- `sel`: 选择状态（图片上传和文案编辑）
- `suc`: 成功状态（发布成功展示）

### 3. 功能说明

#### 图片上传功能
- **上传方式**：支持相机拍照和相册选择
- **格式限制**：仅支持jpg/png/jpeg格式
- **大小限制**：可配置最大文件大小（默认10MB）
- **数量限制**：仅限上传1张图片
- **交互反馈**：超出限制时显示相应提示信息

#### 文案编辑功能
- **输入限制**：最多输入1000字
- **字数提示**：实时显示当前字数/最大字数
- **格式支持**：纯文本输入，不支持富文本
- **交互反馈**：达到字数上限时显示提示

#### 发布流程
1. **前置检查**：必须上传图片并填写描述
2. **微信授权**：首次发布需要授权头像昵称
3. **确认弹窗**：显示发布内容预览
4. **发布执行**：调用后端API进行发布
5. **成功展示**：显示发布成功页面

## 配置说明

### 图片资源配置

在 `config.js` 中配置图片资源路径：

```javascript
export const xingmaLabConfig = {
  baseUrl: 'https://factory-walk.feihe.com',
  images: {
    background: '/farqbxzczytcami/images/XingmaLabPublishPage/XingmaLabPublishPageBg.png',
    // ... 其他图片配置
  }
}
```

### 上传配置

```javascript
upload: {
  maxSize: 10 * 1024 * 1024, // 10MB，待定
  maxSizeText: '照片太大啦，换一张试试吧～',
  maxWords: 1000,
  maxWordsText: '字数已达上限',
  allowedTypes: ['jpg', 'png', 'jpeg'],
  maxCount: 1
}
```

### 发布成功文案配置

```javascript
successMessages: [
  '最好的礼物不是玩具，是陪宝贝长大的光阴。欢迎将宝贝的珍贵回忆，存入你的"时光银行"。',
  '时光会走远，影像能长存。星妈会，为您珍藏每一份稚的美好。',
  // ... 更多文案
]
```

## 样式定制

### 主要样式类

- `.xingmalabpublishpage`: 主容器
- `.collection-image-area`: 图片上传区域
- `.collection-description-area`: 文案编辑区域
- `.confirm-popup`: 确认发布弹窗
- `.xingmalabpublishpagenosel`: 未选择状态容器
- `.xingmalabpublishpagesel`: 选择状态容器
- `.xingmalabpublishpagesuc`: 成功状态容器

### 响应式断点

- 默认：750rpx 宽度（移动端）
- 响应式：小于750px时自动适配为100vw

### 动画效果

- `fadeIn`: 页面淡入动画
- `slideInUp`: 图片和底部容器从下往上滑入动画
- 上传区域和文案区域的滑入动画

## 交互功能

### 图片上传

```javascript
const handleImageUpload = () => {
  uni.chooseImage({
    count: 1,
    sizeType: ['original'],
    sourceType: ['album', 'camera'],
    success: (res) => {
      // 处理图片选择和验证
    }
  })
}
```

### 文案编辑

```javascript
const handleDescriptionInput = (e) => {
  const value = e.detail.value
  if (value.length > config.upload.maxWords) {
    // 显示字数超限提示
  }
}
```

### 发布流程

```javascript
const handlePublishBtnClick = async () => {
  // 检查前置条件
  if (!canPublish.value) return
  
  // 检查微信授权
  if (!hasAuthorized.value) {
    await requestWechatAuth()
    return
  }
  
  // 显示确认弹窗
  showConfirmPopup()
}
```

### 微信授权

```javascript
const requestWechatAuth = () => {
  return new Promise((resolve) => {
    uni.getUserProfile({
      desc: '用于完善用户资料',
      success: (res) => {
        hasAuthorized.value = true
        resolve(true)
      },
      fail: (err) => {
        // 处理授权失败
        resolve(false)
      }
    })
  })
}
```

## 开发规范

- 使用Vue 3 Composition API
- 遵循项目ESLint和Prettier规范
- 使用Less预处理器
- 支持uni-app跨平台开发
- 使用响应式数据管理状态
- 集成微信授权API

## 注意事项

1. 确保图片资源路径正确配置
2. 图片资源需要支持HTTPS协议
3. 组件使用绝对定位布局，注意父容器样式设置
4. 微信授权需要在小程序环境中使用
5. 图片上传大小限制可根据实际需求调整
6. 发布成功文案会随机显示，增加用户体验
7. 确认弹窗使用uni-popup组件，确保已安装

## 更新日志

- v1.0.0: 初始版本，支持三种状态展示
- v1.1.0: 新增图片上传功能，支持格式和大小限制
- v1.2.0: 新增文案编辑功能，支持字数限制和实时统计
- v1.3.0: 新增发布流程管理，包含微信授权和确认弹窗
- v1.4.0: 新增发布成功页面，支持随机文案展示
- 支持动态资源管理和响应式设计
- 集成微信授权和分享API
- 添加交互动画和状态反馈
