import {
  HTTP_STATUS
} from '../config.js'

// request.js
// 通常可以吧 baseUrl 单独放在一个 js 文件了
// const baseUrl = "http://172.16.224.178:7777/pmall";
// const baseUrl = "https://momclub-uat.feihe.com/pmall";//测试环境
const baseUrl = 'https://essence.jzvcode.com/feihe' //生产环境

const request = (options = {}) => {
  // 对options.data 进行一些处理 
  // 如果没有传入 memberId ，则从本地存储中获取
  console.log(options.data, 'options.data')
  if (!options.data?.memberId) {
    options.data.memberId = uni.getStorageSync('memberId') || ''
  }
  return new Promise((resolve, reject) => {
    uni
      .request({
        url: baseUrl + options.url || '',
        method: options.type || 'GET',
        data: options.data || {},
        header: {
          ...options.header,
        },
      })
      .then((data) => {
        console.log('request data ===>', data)
        if (data.statusCode !== HTTP_STATUS.SUCCESS) {
          uni.showToast({
            title: data.errMsg,
            icon: 'none',
          })
          reject(data)
        } else {
          resolve(data.data)
        }
        // else if (!data.data?.ok) {
        //   uni.showToast({
        //     title: data.data?.message,
        //     icon: 'none',
        //   })
        //   reject(data.data)
        // }
      })
      .catch((error) => {
        reject(error)
      })
  })
}

const get = (url, data, options = {}) => {
  options.type = 'GET'
  options.data = data
  options.url = url
  return request(options)
}

const post = (url, data, options = {}) => {
  options.type = 'POST'
  options.data = data
  options.url = url
  return request(options)
}

export default {
  request,
  api: {
    get,
    post,
  },
}