import {
	useGlobalStore
} from '../stores/global.js';
import {
	storeToRefs
} from 'pinia';
import {
	HTTP_STATUS
} from './config.js'

const globalStore = useGlobalStore();
const {
	cuk
} = storeToRefs(globalStore);

// request.js
// 通常可以吧 baseUrl 单独放在一个 js 文件了
// const baseUrl = "http://172.16.230.108:7777/pmall";
// const baseUrl = "https://momclub-uat.feihe.com/pmall";//测试环境
const baseUrl = "https://momclub-test.feihe.com/pmall";
// let baseUrl = "https://momclub.feihe.com/pmall";//生产环境   
// const baseUrl = "https://docs.dui88.com/mock/1956/api";//mock
// const baseUrl = "https://feihe.m.duibatest.com.cn/pmall"

const request = (options = {}) => {
	// 在这里可以对请求头进行一些设置
	// 例如：
	// options.header = {
	//      "Content-Type": "application/x-www-form-urlencoded"
	// }
	// if(options.url == '/c/ai/chat/query'){
	// baseUrl = "https://docs.dui88.com/mock/1956";
	// }

	return new Promise((resolve, reject) => {
		uni
			.request({
				url: baseUrl + options.url || "",
				method: options.type || "GET",
				data: options.data || {},
				header: {
					...options.header,
					cuk: cuk.value || undefined
				},
			})
			.then((data) => {
				if (data.statusCode !== HTTP_STATUS.SUCCESS) {
					// uni.showToast({
					// 	title: data.errMsg,
					// 	icon: 'none'
					// });
					// 返回完整的响应数据，包括状态码和错误信息
					reject({
						statusCode: data.statusCode,
						errMsg: data.errMsg,
						data: data.data,
						success: false
					});
					globalStore.setIsShowLoading(false);
				}
				else if (!data.data?.ok) {
					// uni.showToast({
					// 	title: data.data?.message,
					// 	icon: 'none'
					// });
					// 返回业务逻辑错误的数据
					reject({
						...data.data,
						statusCode: data.statusCode,
						success: false
					});
					globalStore.setIsShowLoading(false);
				}
				else {
					resolve(data.data);
				}
			})
			.catch((error) => {
				// 网络错误或其他异常
				reject({
					statusCode: -1,
					errMsg: error.errMsg || '网络请求失败',
					data: null,
					success: false,
					error: error
				});
				globalStore.setIsShowLoading(false);
			});
	});
};

const get = async (url, data, options = {}) => {
	options.type = "GET";
	options.data = data;
	options.url = url;

	try {
		return await request(options);
	} catch (error) {
		// 返回错误数据，让调用方可以处理
		return error;
	}
};

const post = async (url, data, options = {}) => {
	options.type = "POST";
	options.data = data;
	options.url = url;

	console.log('post options1111111:', options);

	try {
		return await request(options);
	} catch (error) {
		// 返回错误数据，让调用方可以处理
		return error;
	}
};

export default {
	request,
	api: {
		get,
		post
	}
};