import requestModule from '../request.js'
const {api} = requestModule

/**
 * 获取扫码积分页渲染
 * @returns
 */
export const getPageImgInfo = () => api.get('/xmh/old/miniProgramPicUrls');

/**
 * 获取扫码积分上传图片数量
 * @returns
 */
export const getScanPicNum = () => api.get('/xmh/old/scanPicNum');

/**
 * 获取token
 * @returns
 */
export const getToken = () =>{
	return new Promise((resolve, reject) => {
	    api.get('/xmh/old/scan/getToken', { uploadType: 'scan' })
	        .then(res => {
	            resolve(res) // 成功时返回数据
	        })
	        .catch(err => {
	            reject(err) // 失败时返回错误
	        })
	  })
}

/**
 * 扫码
 */
export const getScanCode = (data) => {
  return new Promise((resolve, reject) => {
    api.post('/xmh/old/scanCodeInfo', { ...data })
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
};
