const version = 'v2'
const baseUrl = 'http://127.0.0.1:8080/activity/1015'
export const getCdnUrl = (path) => `${baseUrl}/${version}/${path}`

import closeBtnUrl from '@/assets/images/close-btn.png'

// 活动规则弹窗配置
export const act1015RuleModalConfig = {
  // 图片配置
  images: {
    background: `act1015Component/act1015RuleModal/${version}/act1015RuleModalBg.png`,
    textImg: `act1015Component/act1015RuleModal/${version}/act1015RuleModalTextImg.png`,
    closeBtn: closeBtnUrl
  },

  // 文本配置
  texts: {
    closeButton: '关闭',
    ruleTitle: '活动规则'
  },

  // 弹窗配置
  modal: {
    width: 550,
    height: 667,
    animationDuration: 300
  }
}

// 获取图片URL的工具函数
export const getImageUrl = (imagePath) => {
  return imagePath
}
