import {
	defineStore
} from 'pinia';

const cuk = uni.getStorageSync('cuk')

export const useGlobalStore = defineStore('global', {
	state: () => {
		return {
			cuk: cuk, // 用户登录后获取的凭证，获取用户、宝宝信息接口时使用
		};
	},
	actions: {
		/**
		 * 设置用户cuk
		 * @param {Object} cuk
		 */
		setCuk(cuk) {
			this.cuk = cuk;
			uni.setStorageSync('cuk', cuk);
		}
	},
});