import requestModule from './request.js';
const { api } = requestModule;

/**
 * 获取用户信息
 * @param {*} cuk
 * @returns
 */
export const fetchUserInfo = (cuk) =>
  api.get('/c/user/memberInfo', {
    cuk,
  });

/**
 * 获取宝宝信息
 * @param {*} cuk
 * @returns
 */
export const fetchBabyInfo = (cuk) =>
  api.get('/c/user/babyInfo', {
    cuk,
  });

/**
 * 根据wx.login接口返回的code完成登录
 * @param {*} code
 * @returns
 */
export const autoLoginByCode = (code) =>
  api.get('/c/login/autologin', {
    code,
  });

/**
 * 手机号授权，调用微信手机号快速验证组件，获取encryptedData、iv、code
 * 通过此接口完成手机号授权，注册新用户
 * @param {*} data : {phoneEncryptedData, phoneIv, code}
 * @returns
 */
export const fetchAutoPhone = (data) => api.post('/c/login/authPhone', data);
