import {
	useGlobalStore
} from '../stores/global.js';
import {
	storeToRefs
} from 'pinia';
import {
	HTTP_STATUS
} from './config.js'

const globalStore = useGlobalStore();
const {
	cuk
} = storeToRefs(globalStore);

// request.js
// 通常可以吧 baseUrl 单独放在一个 js 文件了
const baseUrl = "http://172.16.230.108:7777/pmall";

const request = (options = {}) => {
	// 在这里可以对请求头进行一些设置
	// 例如：
	// options.header = {
	//      "Content-Type": "application/x-www-form-urlencoded"
	// }
	return new Promise((resolve, reject) => {
		uni
			.request({
				url: baseUrl + options.url || "",
				method: options.type || "GET",
				data: options.data || {},
				header: {
					...options.header,
					cuk: cuk.value || undefined
				},
			})
			.then((data) => {
				// console.log('request data ===>', data);
				if (data.statusCode !== HTTP_STATUS.SUCCESS) {
					uni.showToast({
						title: data.errMsg,
						icon: 'error'
					});
					reject(data);
				} else if (!data.data?.ok) {
					uni.showToast({
						title: data.data?.message,
						icon: 'error'
					});
					reject(data.data);
				} else {
					resolve(data.data);
				}
				// const [err, res] = data;
				// TODO uni.showToast errMsg

			})
			.catch((error) => {
				reject(error);
			});
	});
};

const get = (url, data, options = {}) => {
	options.type = "GET";
	options.data = data;
	options.url = url;
	return request(options);
};

const post = (url, data, options = {}) => {
	options.type = "POST";
	options.data = data;
	options.url = url;
	return request(options);
};

export default {
	request,
	api: {
		get,
		post
	}
};