const version = 'v1'
// 抽奖页面配置
export const lotteryConfig = {
	// 页面状态
	states: {
		NORMAL: 'normal',
		DRAWING: 'drawing',
		COMPLETED: 'completed'
	},

	// 图片配置
	images: {
		background: `LotteryPage/${version}/LotteryPageBg.png`,
		turnTableBg: `LotteryPage/${version}/LotteryPageTurnTableBg.png`,
		turnTableLogo: `LotteryPage/${version}/LotteryPageTurnTableLogo.png`,
		awards6Bg: `LotteryPage/${version}/LotteryPageTurnTableAwards6Bg.png`,
		awards5Bg: `LotteryPage/${version}/LotteryPageTurnTableAwards5Bg.png`,
		awards4Bg: `LotteryPage/${version}/LotteryPageTurnTableAwards4Bg.png`,
		awards3Bg: `LotteryPage/${version}/LotteryPageTurnTableAwards3Bg.png`,
		awards2Img: `LotteryPage/${version}/LotteryPageTurnTableAwards2Img.png`,
		awards1Img: `LotteryPage/${version}/LotteryPageTurnTableAwards1Img.png`,
		title: `LotteryPage/${version}/LotteryPageTitle.png`,
		ruleBtn: `LotteryPage/${version}/LotteryPageRuleBtn.png`,
		awardBtn: `LotteryPage/${version}/LotteryPageAwardBtn.png`,
		noticeConBg: `LotteryPage/${version}/LotteryPageNoticeConBg.png`,
		noticeConSoundIcon: `LotteryPage/${version}/LotteryPageNoticeConSoundIcon.png`,
		drawBtn: `LotteryPage/${version}/LotteryPageDrawBtn.png`
	},

	// 奖品配置
	awards: [
		{
			id: 1,
			name: 'N47度 水果玉米汁',
			type: 'product',
			probability: 0.1
		},
		{
			id: 2,
			name: 'N47度 水果玉米汁',
			type: 'product',
			probability: 0.15
		},
		{
			id: 3,
			name: 'N47度 水果玉米汁',
			type: 'product',
			probability: 0.2
		},
		{
			id: 4,
			name: 'N47度 水果玉米汁',
			type: 'product',
			probability: 0.25
		},
		{
			id: 5,
			name: '感谢参与',
			type: 'thanks',
			probability: 0.2
		},
		{
			id: 6,
			name: 'N47度 水果玉米汁',
			type: 'product',
			probability: 0.1
		}
	],

	// 文本配置
	texts: {
		title: '幸运大转盘',
		ruleTitle: '活动规则',
		awardTitle: '奖品列表',
		drawButton: '立即抽奖',
		remainingTimes: '剩余次数：',
		noTimesLeft: '抽奖次数已用完',
		drawingText: '抽奖中...',
		congratulations: '恭喜中奖',
		youGot: '您获得了：'
	},

	// 抽奖配置
	lottery: {
		maxTimes: 1, // 最大抽奖次数
		animationDuration: 2000, // 抽奖动画时长
		rotationSpeed: 5 // 转盘旋转速度
	}
}

// 获取图片URL的工具函数
export const getImageUrl = (imagePath) => {
	return imagePath
}

// 获取随机公告
export const getRandomNotice = () => {
	const notices = [
		'用户152****8839 获得了 XXXXXX',
		'用户138****5678 获得了 YYYYYY',
		'用户159****1234 获得了 ZZZZZZ',
		'恭喜用户获得大奖！',
		'又有用户中奖了！'
	]
	return notices[Math.floor(Math.random() * notices.length)]
}

// 根据概率获取奖品
export const getRandomAward = (awards) => {
	const random = Math.random()
	let cumulativeProbability = 0
	
	for (const award of awards) {
		cumulativeProbability += award.probability
		if (random <= cumulativeProbability) {
			return award
		}
	}
	
	// 默认返回最后一个奖品
	return awards[awards.length - 1]
}
