# 抽奖页面弹窗组件

## 组件结构

```
activity0915/lottery/
├── lottery.vue                    # 主抽奖页面
├── config.js                      # 主页面配置
├── lotterypage.less              # 主页面样式
└── components/                    # 弹窗组件目录
    ├── ruleModal/                 # 规则弹窗
    │   ├── ruleModal.vue
    │   ├── config.js
    │   └── rulemodal.less
    ├── drawSucModal/              # 抽奖成功弹窗
    │   ├── drawSucModal.vue
    │   ├── config.js
    │   └── drawsucmodal.less
    └── drawFailModal/             # 抽奖失败弹窗
        ├── drawFailModal.vue
        ├── config.js
        └── drawfailmodal.less
```

## 组件说明

### 1. RuleModal (规则弹窗)
- **功能**: 显示活动规则说明
- **Props**: 
  - `visible`: Boolean - 控制弹窗显示/隐藏
- **Events**:
  - `close`: 关闭弹窗事件

### 2. DrawSucModal (抽奖成功弹窗)
- **功能**: 显示抽奖成功和奖品信息
- **Props**: 
  - `visible`: Boolean - 控制弹窗显示/隐藏
  - `awardName`: String - 中奖奖品名称
- **Events**:
  - `close`: 关闭弹窗事件
  - `happy-get`: 点击"开心领取"按钮事件

### 3. DrawFailModal (抽奖失败弹窗)
- **功能**: 显示抽奖失败提示
- **Props**: 
  - `visible`: Boolean - 控制弹窗显示/隐藏
- **Events**:
  - `close`: 关闭弹窗事件
  - `i-know`: 点击"我知道了"按钮事件

## 使用方法

### 在主页面中引入组件
```vue
<template>
  <view class="lotterypage">
    <!-- 主页面内容 -->
    
    <!-- 规则弹窗 -->
    <RuleModal 
      :visible="showRuleModal" 
      @close="handleRuleModalClose" 
    />

    <!-- 抽奖成功弹窗 -->
    <DrawSucModal 
      :visible="showDrawSucModal" 
      :award-name="currentAwardName"
      @close="handleDrawSucModalClose"
      @happy-get="handleHappyGet"
    />

    <!-- 抽奖失败弹窗 -->
    <DrawFailModal 
      :visible="showDrawFailModal" 
      @close="handleDrawFailModalClose"
      @i-know="handleIKnow"
    />
  </view>
</template>

<script setup>
import RuleModal from './components/ruleModal/ruleModal.vue'
import DrawSucModal from './components/drawSucModal/drawSucModal.vue'
import DrawFailModal from './components/drawFailModal/drawFailModal.vue'

// 弹窗状态
const showRuleModal = ref(false)
const showDrawSucModal = ref(false)
const showDrawFailModal = ref(false)
const currentAwardName = ref('')

// 事件处理
const handleRuleModalClose = () => {
  showRuleModal.value = false
}

const handleDrawSucModalClose = () => {
  showDrawSucModal.value = false
}

const handleHappyGet = () => {
  showDrawSucModal.value = false
  // 处理奖品领取逻辑
}

const handleDrawFailModalClose = () => {
  showDrawFailModal.value = false
}

const handleIKnow = () => {
  showDrawFailModal.value = false
  // 处理失败确认逻辑
}
</script>
```

## 抽奖逻辑

抽奖页面会根据奖品配置中的概率进行随机抽奖：

```javascript
// 根据奖品概率判断是否中奖
const isWin = Math.random() < award.probability

if (isWin) {
  // 中奖 - 显示成功弹窗
  currentAwardName.value = award.name
  showDrawSucModal.value = true
} else {
  // 未中奖 - 显示失败弹窗
  showDrawFailModal.value = true
}
```

## 样式说明

所有弹窗组件都使用绝对定位，覆盖在主页面之上。弹窗背景使用半透明遮罩，确保用户注意力集中在弹窗内容上。

每个弹窗组件都有独立的样式文件，可以根据设计需求进行调整。
