import sensors, {
  enableVue3MpClick,
} from "./js_sdk/Sensorsdata-UniPlugin-JS/index";

const init = (SENSORS_URL) => {
  sensors.setPara({
    name: "sensors",
    server_url: SENSORS_URL,
    show_log: false,
    autoTrack: {
      appLaunch: true, // 默认为 true，false 则关闭 $MPLaunch 事件采集
      appShow: true, // 默认为 true，false 则关闭 $MPShow 事件采集
      appHide: true, // 默认为 true，false 则关闭 $MPHide 事件采集
      pageShow: true, // 默认为 true，false 则关闭 $MPViewScreen 事件采集
      pageShare: true, // 默认为 true，false 则关闭 $MPShare 事件采集
      mpClick: false, // 点击事件全部自定义元数据触发，不采用默认全局点击
      mpFavorite: true, // 默认为 true，false 则关闭 $MPAddFavorites 事件采集
      pageLeave: true, // 默认为 false， true 则开启 $MPPageLeave事件采集
    },
  });

  enableVue3MpClick();

  // sensors.init();
};

const login = (ext) => {
  console.log("login", ext);
  sensors.register({
    miniName: "飞鹤星妈会",
    ...ext,
  });
  sensors.login(ext.memberid);
};

/**
 * 传感器埋点
 * @param {*} evt 事件对象，通过节点data-log属性配置
 * 
 * xcxClick 有值就是点击事件  
 * xcxPage 有值就是页面浏览事件
 * 两者可以同时写，也可以只写其中之一，配置哪个就发哪个
 
 * <image :data-log="{
					xcxClick:'首页-首屏页面点击',
					pageName:'首页-首屏',
					buttonName:'搜索框'
				}" class="btnsearch"
					@tap="goSearchHandler" :src="$baseUrl + 'homepage/btnsearch.png'">
				</image>
 */
const sensorLog = (evt) => {
  const _dataset = evt.currentTarget.dataset;
  const logObj = _dataset.log;
  if (!logObj) {
    return;
  }
  const { xcxPage, xcxClick } = logObj;

  let trackObj = {};
  for (let key in logObj) {
    trackObj[key] = logObj[key];
  }
  if (xcxPage && xcxPage.length > 0) {
    // console.warn("xcxPage", trackObj);
    sensors.track("xcxPage", {
      ...trackObj,
    });
  }
  if (xcxClick && xcxClick.length > 0) {
    // console.warn("xcxClick", trackObj);
    sensors.track("xcxClick", {
      ...trackObj,
    });
  }
};
/**
 * 主动通过配置数据触发埋点
 * @param {*} evt
 */
const sensorLogTake = (logObj) => {
  if (!logObj) {
    return;
  }
  const evt = {
    currentTarget: {
      dataset: {
        log: logObj,
      },
    },
  };
  sensorLog(evt);
};

const sensorComponentLog = (evt) => {
  const _dataset = evt.currentTarget.dataset;
  const logObj = _dataset.comlog;
  if (!logObj) {
    return;
  }
  const { xcxComponentExposure, xcxComponentClick } = logObj;

  let trackObj = {};
  for (let key in logObj) {
    trackObj[key] = logObj[key];
  }
  if (xcxComponentExposure && xcxComponentExposure.length > 0) {
    // console.warn("-----xcxComponentExposure-----", trackObj);
    sensors.track("xcxComponentExposure", {
      ...trackObj,
    });
  }
  if (xcxComponentClick && xcxComponentClick.length > 0) {
    // console.warn("-----xcxComponentClick-----", trackObj);
    sensors.track("xcxComponentClick", {
      ...trackObj,
    });
  }
};
/**
 * 主动通过配置数据触发埋点
 * @param {*} evt
 */
const sensorComponentLogTake = (logObj) => {
  if (!logObj) {
    return;
  }
  const evt = {
    currentTarget: {
      dataset: {
        comlog: logObj,
      },
    },
  };
  sensorComponentLog(evt);
};

const sensorPopLog = (evt) => {
  const _dataset = evt.currentTarget.dataset;
  const logObj = _dataset.poplog;
  if (!logObj) {
    return;
  }
  const { xcxPopExposure, xcxPopClick } = logObj;

  let trackObj = {};
  for (let key in logObj) {
    trackObj[key] = logObj[key];
  }
  if (xcxPopExposure && xcxPopExposure.length > 0) {
    // console.warn("-----xcxPopExposure-----", trackObj);
    sensors.track("xcxPopExposure", {
      ...trackObj,
    });
  }
  if (xcxPopClick && xcxPopClick.length > 0) {
    // console.warn("-----xcxPopClick-----", trackObj);
    sensors.track("xcxPopClick", {
      ...trackObj,
    });
  }
};
/**
 * 主动通过配置数据触发埋点
 * @param {*} evt
 */
const sensorPopLogTake = (logObj) => {
  if (!logObj) {
    return;
  }
  const evt = {
    currentTarget: {
      dataset: {
        poplog: logObj,
      },
    },
  };
  sensorPopLog(evt);
};

const sensorUserLogTake = (logObj) => {
  if (!logObj) {
    return;
  }
  sensors.track("xcxUserStatus", {
    ...logObj,
  });
};

export default {
  init,
  sensors,
  login,
  sensorLog,
  sensorLogTake,
  sensorComponentLog,
  sensorComponentLogTake,
  sensorPopLog,
  sensorPopLogTake,
  sensorUserLogTake
};
