// API 配置文件
export const BASE_URL = 'https://api.example.com' // 替换为实际的 API 地址

// 请求超时时间
export const TIMEOUT = 10000

// 请求状态码
export const HTTP_STATUS = {
  SUCCESS: 200,
  CREATED: 201,
  ACCEPTED: 202,
  CLIENT_ERROR: 400,
  AUTHENTICATE: 401,
  FORBIDDEN: 403,
  NOT_FOUND: 404,
  SERVER_ERROR: 500,
  BAD_GATEWAY: 502,
  SERVICE_UNAVAILABLE: 503,
  GATEWAY_TIMEOUT: 504
}

// 错误信息
export const ERROR_MESSAGE = {
  NETWORK_ERROR: '网络异常，请检查您的网络连接',
  TIMEOUT_ERROR: '请求超时，请稍后重试',
  SERVER_ERROR: '服务器异常，请稍后重试',
  UNKNOWN_ERROR: '未知错误，请稍后重试'
} 