import { defineStore } from "pinia";
import {
    assessmentSave
} from "../api/shengzhangTools.js";

export const useShengzhangStore = defineStore("shengzhangInfo", {
  state: () => {
    return {
      shengzhangInfo: null,
    };
  },
  actions: {
    /**
     * 设置生长测评结果
     * @param {Object} userInfo
     */
    setShengzhangInfo(shengzhangInfo) {
      this.shengzhangInfo = shengzhangInfo;
    },

    async assessmentSave(submitData) {

      const data = await assessmentSave(submitData);
      if(data.success){
        data.data.success = data.success;
        this.setShengzhangInfo(data.data);
      }
    },

  },
});
