import {
	defineStore
} from 'pinia';

const cuk = uni.getStorageSync('cuk')
const openId = uni.getStorageSync('openId')
const unionId = uni.getStorageSync('unionId')

export const useGlobalStore = defineStore('global', {
	state: () => {
		return {
			cuk: cuk, // 用户登录后获取的凭证，调用接口时headers中携带
			curTabIndex: 0, // 当前Tab索引
			isWxFriendCircle:false,
			isShowLoading: false,
			openId: openId,
			unionId: unionId,
			baseUrl: '',
			isShowInvitePrizePanel: false, // 是否显示邀请奖品弹窗
			isShowTaskComplete: false, // 是否显示任务完成弹窗
			taskCompletePoints: 100, // 任务完成获得的积分
			taskCompleteTitle: 'xxx', // 任务完成的任务名称
			isShowTaskPop: false, // 是否显示任务弹窗
			isShowTaskPerson: false, // 是否显示任务信息弹窗
			taskTodo: [], // 任务数据
			invateUseType: '', // 邀请用户类型
		};
	},
	actions: {
		setBaseUrl(url){
			this.baseUrl = url
		},
		/**
		 * 设置用户cuk
		 * @param {Object} cuk
		 */
		setCuk(cuk,openId,unionId) {
			this.cuk = cuk;
			this.openId = openId;
			this.unionId = unionId;
			uni.setStorageSync('openId', openId);
			uni.setStorageSync('unionId', unionId);
			uni.setStorageSync('cuk', cuk);
		},
		/**
		 * 设置当前Tab索引
		 * @param {number} index
		 */
		setCurTabIndex(index) {
			this.curTabIndex = index;
		},
		
		/**
		 * 设置当前是否是小程序朋友圈单页环境
		 * @param {boolean} v
		 */
		setIsWxFriendCircle(v){
			this.isWxFriendCircle = v
		},
		
		setIsShowLoading(v){
			this.isShowLoading = v
		},
		
		/**
		 * 显示任务完成弹窗
		 * @param {number} points 获得的积分
		 * @param {string} taskTitle 任务名称
		 */
		showTaskComplete(points = 100, taskTitle = 'xxx') {
			this.taskCompletePoints = points;
			this.taskCompleteTitle = taskTitle;
			this.isShowTaskComplete = true;
		},
		
		/**
		 * 显示任务弹窗
		 * @param {Array} taskTodo 任务数据
		 */
		showTaskPop(taskTodo = []) {
			this.taskTodo = taskTodo;
			this.isShowTaskPop = true;
		},
		
		/**
		 * 关闭任务弹窗
		 */
		closeTaskPop() {
			this.isShowTaskPop = false;
		},
		
		/**
		 * 显示任务信息弹窗
		 */
		showTaskPerson() {
			this.isShowTaskPerson = true;
		},
		
		/**
		 * 关闭任务信息弹窗
		 */
		closeTaskPerson() {
			this.isShowTaskPerson = false;
		}
	},
});