import {onMounted} from 'vue'
import md from '@/md.js'
import {MdConfig} from "./types";

export function useMD(mdConfig: MdConfig, autoLogExposure = true) {

	function logExposure() {
		const {pageName, componentName, componentContent} = mdConfig || {}
		if (!pageName || !componentName || !componentContent) {
			return
		}
		md.sensorComponentLogTake({
			xcxComponentExposure: "true",
			pageName,
			componentName,
			componentContent,
		})
	}

	function logClick() {
		const {pageName, componentName, componentContent} = mdConfig || {}
		if (!pageName || !componentName || !componentContent) {
			return
		}
		md.sensorComponentLogTake({
			xcxComponentClick: "true",
			pageName,
			componentName,
			componentContent,
		})
	}

	if (autoLogExposure) {
		onMounted(() => {
			if (mdConfig?.logExposure) {
				logExposure()
			}
		})
	}

	return {
		logClick,
		logExposure,
	}
}
