# 星妈实验室发布页面

## 功能概述

这是一个星妈实验室的藏品发布页面，支持用户上传藏品图片、编辑文案介绍，并进行发布。

## 主要功能

### 1. 藏品图片上传
- **限制数量**：仅限上传1张图片
- **尺寸限制**：固定宽度，不限制高度比例
- **大小限制**：可配置最大文件大小（默认10MB）
- **格式支持**：jpg、png、jpeg
- **交互方式**：点击上传区域拉起相机/相册选择器
- **错误提示**：超过大小限制时显示"照片太大啦，换一张试试吧～"

### 2. 重新上传功能
- **触发方式**：点击"重新上传"按钮
- **选择方式**：拉起相机/相册图库
- **格式限制**：jpg/png/jpeg
- **位置**：已上传图片右下角

### 3. 藏品文案介绍
- **字数限制**：最多1000字
- **输入方式**：点击拉起输入键盘
- **内容类型**：纯文本，不支持富文本
- **字数提示**：实时显示当前字数/最大字数
- **超限提示**：达到上限时显示"字数已达上限"

### 4. 发布按钮交互
- **首次发布**：需要拉起微信头像昵称授权
- **授权处理**：
  - 允许：进入确认弹窗页面
  - 拒绝：停留当前页面，再次点击重新拉起授权
- **非首次发布**：直接进入确认弹窗页面
- **确认弹窗**：显示上传的图片和文案，用户确认后才发布
- **次数限制**：后端校验用户发布次数是否已达上限

## 技术实现

### 状态管理
- `NOSEL`：未选择状态
- `SEL`：选择状态（已上传图片和文案）
- `SUC`：发布成功状态

### 关键方法
- `handleImageUpload()`：处理图片上传
- `handleDescriptionInput()`：处理文案输入
- `handlePublishBtnClick()`：处理发布按钮点击
- `requestUserInfo()`：请求用户信息授权
- `checkPublishLimit()`：检查发布次数限制

### 配置项
- 图片大小限制：`config.upload.maxSize`
- 文案字数限制：`config.upload.maxWords`
- 支持的文件格式：`config.upload.allowedTypes`

## 使用说明

1. 用户进入页面后，点击"记录这个时刻"按钮进入选择状态
2. 上传藏品图片（必填）
3. 输入藏品文案介绍（可选，最多1000字）
4. 点击发布按钮
5. 首次发布需要授权微信头像昵称
6. 确认发布内容后完成发布
7. 显示发布成功页面

## 注意事项

- 保持原有样式和图片格局不变
- 所有交互都遵循微信小程序规范
- 错误处理完善，用户体验友好
- 支持响应式布局
- 遵循Vue 3 Composition API开发规范