import App from "./App";
// import apiRequest from "@/api/request.js";
import * as Pinia from "pinia";
import sensors from "sa-sdk-miniprogram";

const SENSORS_URL = "https://sensors.feihe.com/sa?project=XMH_Content";

const BASE_URL = "https://duiba.oss-cn-hangzhou.aliyuncs.com/fh/";
// const BASE_URL = 'https://firmus-member-test-1253290912.cos.ap-beijing.myqcloud.com/xmh-mini-program/';
sensors.setPara({
  name: "sensors",
  server_url: SENSORS_URL,
  show_log: true,
  autoTrack: {
    appLaunch: true, // 默认为 true，false 则关闭 $MPLaunch 事件采集
    appShow: true, // 默认为 true，false 则关闭 $MPShow 事件采集
    appHide: true, // 默认为 true，false 则关闭 $MPHide 事件采集
    pageShow: true, // 默认为 true，false 则关闭 $MPViewScreen 事件采集
    pageShare: true, // 默认为 true，false 则关闭 $MPShare 事件采集
    mpClick: true, // 默认为 false，true 则开启 $MPClick 事件采集
    mpFavorite: true, // 默认为 true，false 则关闭 $MPAddFavorites 事件采集
    pageLeave: true, // 默认为 false， true 则开启 $MPPageLeave事件采集
  },
});
sensors.init();

// #ifndef VUE3
import Vue from "vue";
import "./uni.promisify.adaptor";

// 全局挂载后使用
// Vue.prototype.$api = apiRequest.api;
Vue.prototype.$baseUrl = BASE_URL;
Vue.prototype.$sensors = sensors;

Vue.config.productionTip = false;
App.mpType = "app";

const app = new Vue({
  ...App,
});
app.$mount();
// #endif

// #ifdef VUE3
import { createSSRApp } from "vue";
export function createApp() {
  const app = createSSRApp(App);
  app.use(Pinia.createPinia());
  // app.config.globalProperties.$api = apiRequest.api;
  app.config.globalProperties.$baseUrl = BASE_URL;
  app.config.globalProperties.$sensors = sensors;
  return {
    app,
    Pinia,
  };
}
// #endif
