// 产检提醒模块相关接口
import requestModule from './request.js';
const { api } = requestModule;

/**
 * 获取产检信息
 * @returns
 */

export const getInfo = (data) => api.get('/maternity_checkup/home',data);

/**
 * 产看产检详情
 * @returns
 */

export const getDetail = (data) => api.get('/maternityCheckup/detail',data);

/**
 * 删除报告单
 * @returns
 */

export const getDelete = (data) => api.get('/maternityCheckup/delete',data);

/**
 * 产检项目列表
 * @returns
 */

export const getExaminationItems = (data) => api.get('/maternityCheckup/examinationItems',data);

/**
 * 修改产检记录
 * @returns
 */

export const getUpdate = (data) => api.post('/maternityCheckup/update',data);

/**
 * 
 * /**
 * 新增产检记录
 * @returns
 */

export const getAdd = (data) => api.post('/maternityCheckup/add',data);

/**
 * 我的报告单列表
 * @returns
 */

export const getReportList = () => api.get('/maternityCheckup/reportList');