# XingmaLab 弹窗组件库

这是一个弹窗组件库，包含多个弹窗组件，用于不同的业务场景。

## 组件列表

### 1. Xingmalabconfirmpop - 确认弹窗组件
用于显示确认对话框，支持确认和取消操作。

### 2. Xingmalabnotimepop - 无时间弹窗组件
用于显示无时间状态的弹窗，通常只有一个按钮。

## 功能特性

- 支持显示/隐藏控制
- 响应式设计
- 图片资源集中配置管理
- 支持版本控制和图片更新
- 统一的样式和交互规范
- 支持自定义文案和样式

## 使用方法

### Xingmalabconfirmpop 组件

```vue
<template>
  <view>
    <button @click="showConfirm = true">显示确认弹窗</button>
    
    <Xingmalabconfirmpop
      :visible="showConfirm"
      title="确认操作"
      confirm-text="确定"
      cancel-text="取消"
      @confirm="handleConfirm"
      @cancel="handleCancel"
      @close="showConfirm = false"
    />
  </view>
</template>

<script setup>
import { ref } from 'vue'
import Xingmalabconfirmpop from '@/components/xingmaLab/Xingmalabconfirmpop.vue'

const showConfirm = ref(false)

const handleConfirm = () => {
  console.log('用户点击了确认')
  showConfirm.value = false
}

const handleCancel = () => {
  console.log('用户点击了取消')
  showConfirm.value = false
}
</script>
```

### Xingmalabnotimepop 组件

```vue
<template>
  <view>
    <button @click="showNoTime = true">显示无时间弹窗</button>
    
    <Xingmalabnotimepop
      :visible="showNoTime"
      title="暂无时间"
      @button-click="handleButtonClick"
      @close="showNoTime = false"
    />
  </view>
</template>

<script setup>
import { ref } from 'vue'
import Xingmalabnotimepop from '@/components/xingmaLab/Xingmalabnotimepop.vue'

const showNoTime = ref(false)

const handleButtonClick = () => {
  console.log('用户点击了按钮')
  showNoTime.value = false
}
</script>
```

## 在发布页面中的使用

### 发布流程弹窗逻辑

在 `XingmaLabPublishPage.vue` 中，我们使用弹窗组件实现了以下逻辑：

1. **发布按钮点击** → 检查发布次数限制
2. **有剩余次数** → 显示确认发布弹窗 (`Xingmalabconfirmpop`)
3. **无剩余次数** → 显示无次数弹窗 (`Xingmalabnotimepop`)

### 代码示例

```vue
<template>
  <!-- 确认发布弹窗 -->
  <Xingmalabconfirmpop
    :visible="showConfirmPopup"
    title="确认发布"
    confirm-text="确认发布"
    cancel-text="取消"
    @confirm="handleConfirmPublish"
    @cancel="handleCancelPublish"
    @close="showConfirmPopup = false"
  />
  
  <!-- 无次数弹窗 -->
  <Xingmalabnotimepop
    :visible="showNoTimePopup"
    title="发布次数已用完"
    @button-click="handleNoTimeButtonClick"
    @close="showNoTimePopup = false"
  />
</template>

<script setup>
import Xingmalabconfirmpop from '@/components/xingmaLab/Xingmalabconfirmpop.vue'
import Xingmalabnotimepop from '@/components/xingmaLab/Xingmalabnotimepop.vue'

// 弹窗显示状态
const showConfirmPopup = ref(false)
const showNoTimePopup = ref(false)

// 发布按钮点击处理
const handlePublishBtnClick = async () => {
  // 检查发布次数限制
  const canPublish = await checkPublishLimit()
  if (!canPublish) {
    // 显示无次数弹窗
    showNoTimePopup.value = true
    return
  }
  
  // 显示确认发布弹窗
  showConfirmPopup.value = true
}

// 确认发布
const handleConfirmPublish = async () => {
  showConfirmPopup.value = false
  // 执行发布逻辑...
}

// 无次数弹窗按钮点击处理
const handleNoTimeButtonClick = () => {
  showNoTimePopup.value = false
  uni.showToast({
    title: '发布次数已用完，请明天再试',
    icon: 'none'
  })
}
</script>
```

## Props

### Xingmalabconfirmpop Props

| 属性名 | 类型 | 默认值 | 说明 |
|--------|------|--------|------|
| visible | Boolean | false | 控制弹窗显示/隐藏 |
| title | String | '确认' | 弹窗标题 |
| confirmText | String | '确认' | 确认按钮文本 |
| cancelText | String | '取消' | 取消按钮文本 |

### Xingmalabnotimepop Props

| 属性名 | 类型 | 默认值 | 说明 |
|--------|------|--------|------|
| visible | Boolean | false | 控制弹窗显示/隐藏 |
| title | String | '暂无时间' | 弹窗标题 |

## Events

### Xingmalabconfirmpop Events

| 事件名 | 说明 | 回调参数 |
|--------|------|----------|
| confirm | 点击确认按钮时触发 | - |
| cancel | 点击取消按钮时触发 | - |
| close | 点击遮罩层时触发 | - |

### Xingmalabnotimepop Events

| 事件名 | 说明 | 回调参数 |
|--------|------|----------|
| button-click | 点击按钮时触发 | - |
| close | 点击遮罩层时触发 | - |

## 图片配置

组件使用集中化的图片配置管理，所有图片路径都在 `config.js` 文件中配置：

```javascript
// 确认弹窗图片配置
images: {
  background: `XingmaLabPop/v1/XingmaLabConfirmPopBg.png`,
  confirmBtn: `XingmaLabPop/v1/XingmaLabConfirmPopConfirmBtn.png`,
  cancelBtn: `XingmaLabPop/v1/XingmaLabCancelBtn.png`
}

// 无时间弹窗图片配置
images: {
  background: `XingmaLabPop/v1/XingmaLabNoTimePopBg.png`,
  button: `XingmaLabPop/v1/XingmaLabNoTimePopBtn.png`
}
```

### 图片目录结构

```
static/
└── XingmaLabPop/
    └── v1/
        ├── XingmaLabConfirmPopBg.png          # 确认弹窗背景
        ├── XingmaLabConfirmPopConfirmBtn.png  # 确认弹窗确认按钮
        ├── XingmaLabCancelBtn.png             # 确认弹窗取消按钮
        ├── XingmaLabNoTimePopBg.png           # 无时间弹窗背景
        └── XingmaLabNoTimePopBtn.png          # 无时间弹窗按钮
```

## 配置管理

### 尺寸配置

```javascript
// 确认弹窗尺寸
dimensions: {
  width: 750,        // 弹窗宽度
  height: 1624,      // 弹窗高度
  background: {      // 背景尺寸
    width: 618,
    height: 557
  },
  confirmBtn: {      // 确认按钮尺寸和位置
    width: 275,
    height: 97,
    left: 318,
    top: 408
  },
  cancelBtn: {       // 取消按钮尺寸和位置
    width: 279,
    height: 101,
    left: 28,
    top: 406
  }
}

// 无时间弹窗尺寸
dimensions: {
  width: 750,        // 弹窗宽度
  height: 1624,      // 弹窗高度
  background: {      // 背景尺寸
    width: 618,
    height: 460
  },
  button: {          // 按钮尺寸和位置
    width: 466,
    height: 97,
    left: 76,
    top: 312
  }
}
```

### 样式配置

```javascript
styles: {
  zIndex: 999,                    // 层级
  borderRadius: '16rpx',          // 圆角
  transition: 'all 0.3s ease'     // 过渡动画
}
```

## 版本控制

组件支持版本控制，通过修改 `config.js` 中的 `version` 变量来管理不同版本的图片资源：

```javascript
const version = 'v1'  // 当前版本
```

## 注意事项

1. **图片资源**: 需要准备对应的背景图片文件并放置在正确的目录结构中
2. **样式单位**: 组件使用 rpx 单位，确保跨平台兼容性
3. **事件处理**: 组件会发射标准事件，父组件可以监听处理
4. **配置管理**: 所有图片路径和尺寸配置都在 `config.js` 中集中管理
5. **版本更新**: 如需更新图片，只需替换文件并更新版本号即可
6. **组件复用**: 多个弹窗组件共享相同的配置管理机制
7. **发布流程**: 在发布页面中，弹窗组件用于二次确认和次数限制提示

## 文件结构

```
components/xingmaLab/
├── Xingmalabconfirmpop.vue    # 确认弹窗组件
├── Xingmalabnotimepop.vue     # 无时间弹窗组件
├── config.js                   # 配置文件
├── README.md                   # 使用说明
├── IMAGES.md                   # 图片资源说明
└── example.vue                 # 使用示例

pages/XingmaLabPublishPage/
├── XingmaLabPublishPage.vue   # 发布页面（使用弹窗组件）
├── test-popup.vue             # 弹窗组件测试页面
└── ...
```
