# 图片资源目录结构

## 目录结构

```
static/
└── XingmaLabPop/
    └── v1/
        ├── XingmaLabConfirmPopBg.png          # 确认弹窗背景图片
        ├── XingmaLabConfirmPopConfirmBtn.png  # 确认弹窗确认按钮图片
        ├── XingmaLabCancelBtn.png             # 确认弹窗取消按钮图片
        ├── XingmaLabNoTimePopBg.png           # 无时间弹窗背景图片
        └── XingmaLabNoTimePopBtn.png          # 无时间弹窗按钮图片
```

## 图片规格说明

### Xingmalabconfirmpop 组件图片

#### 1. XingmaLabConfirmPopBg.png (确认弹窗背景)
- **尺寸**: 618 × 557 像素
- **格式**: PNG (支持透明背景)
- **用途**: 确认弹窗的主要背景图片
- **建议**: 使用高质量图片，确保在不同设备上显示清晰

#### 2. XingmaLabConfirmPopConfirmBtn.png (确认按钮)
- **尺寸**: 275 × 97 像素
- **格式**: PNG (支持透明背景)
- **用途**: 确认按钮的图片
- **建议**: 按钮图片应该清晰，有良好的视觉反馈

#### 3. XingmaLabCancelBtn.png (取消按钮)
- **尺寸**: 279 × 101 像素
- **格式**: PNG (支持透明背景)
- **用途**: 取消按钮的图片
- **建议**: 与确认按钮保持视觉一致性

### Xingmalabnotimepop 组件图片

#### 4. XingmaLabNoTimePopBg.png (无时间弹窗背景)
- **尺寸**: 618 × 460 像素
- **格式**: PNG (支持透明背景)
- **用途**: 无时间弹窗的主要背景图片
- **建议**: 使用高质量图片，确保在不同设备上显示清晰

#### 5. XingmaLabNoTimePopBtn.png (无时间弹窗按钮)
- **尺寸**: 466 × 97 像素
- **格式**: PNG (支持透明背景)
- **用途**: 无时间弹窗的按钮图片
- **建议**: 按钮图片应该清晰，有良好的视觉反馈

## 图片命名规范

- 使用 PascalCase 命名方式
- 文件名清晰描述图片用途
- 版本号使用 `v1`, `v2` 等格式
- 保持命名的一致性和可读性
- 按组件功能分组命名

## 图片优化建议

1. **文件大小**: 建议单张图片不超过 100KB
2. **图片质量**: 使用适当的压缩比例，平衡质量和文件大小
3. **格式选择**: PNG 格式适合需要透明背景的图片
4. **响应式**: 考虑为不同分辨率设备准备不同尺寸的图片
5. **一致性**: 保持同一组件内图片的视觉风格一致

## 部署说明

1. 将图片文件放置在对应的目录结构中
2. 确保图片文件权限正确
3. 测试图片在不同设备上的显示效果
4. 验证图片加载性能
5. 检查图片在不同分辨率下的显示效果

## 注意事项

- 图片路径在 `config.js` 中配置
- 组件会自动根据配置加载对应的图片
- 如需更换图片，只需替换文件并更新版本号
- 建议使用 CDN 加速图片加载
- 图片尺寸和位置信息在配置文件中统一管理
- 支持版本控制，便于图片资源更新和管理
