# XingmaLab 弹窗组件图片资源说明

本文档说明 XingmaLab 弹窗组件所需的图片资源，参考 `babyClass` 组件的图片管理方式。

## 图片配置结构

图片资源通过 `xingmalabImages.js` 文件进行配置管理，采用常量对象的方式：

```javascript
export const XINGMALAB_IMAGES = {
  CONFIRM: {
    BG: `XingmaLabPop/v1/XingmaLabConfirmPopBg.png`,
    CONFIRM_BTN: `XingmaLabPop/v1/XingmaLabConfirmPopConfirmBtn.png`,
    CANCEL_BTN: `XingmaLabPop/v1/XingmaLabCancelBtn.png`
  },
  NO_TIME: {
    BG: `XingmaLabPop/v1/XingmaLabNoTimePopBg.png`,
    BTN: `XingmaLabPop/v1/XingmaLabNoTimePopBtn.png`
  }
}
```

## 目录结构

```
static/
└── XingmaLabPop/
    └── v1/
        ├── XingmaLabConfirmPopBg.png          # 确认弹窗背景图片
        ├── XingmaLabConfirmPopConfirmBtn.png  # 确认弹窗确认按钮图片
        ├── XingmaLabCancelBtn.png             # 确认弹窗取消按钮图片
        ├── XingmaLabNoTimePopBg.png           # 无时间弹窗背景图片
        └── XingmaLabNoTimePopBtn.png          # 无时间弹窗按钮图片
```

## 图片规格要求

### 确认弹窗图片

#### 1. XingmaLabConfirmPopBg.png (背景图片)
- **尺寸**: 618rpx × 557rpx
- **格式**: PNG
- **用途**: 确认弹窗的背景图片
- **设计要求**: 透明背景，包含弹窗框架和装饰元素

#### 2. XingmaLabConfirmPopConfirmBtn.png (确认按钮)
- **尺寸**: 275rpx × 97rpx
- **格式**: PNG
- **用途**: 确认按钮的图片
- **设计要求**: 透明背景，包含按钮文字和样式

#### 3. XingmaLabCancelBtn.png (取消按钮)
- **尺寸**: 279rpx × 101rpx
- **格式**: PNG
- **用途**: 取消按钮的图片
- **设计要求**: 透明背景，包含按钮文字和样式

### 无时间弹窗图片

#### 1. XingmaLabNoTimePopBg.png (背景图片)
- **尺寸**: 618rpx × 460rpx
- **格式**: PNG
- **用途**: 无时间弹窗的背景图片
- **设计要求**: 透明背景，包含弹窗框架和提示信息

#### 2. XingmaLabNoTimePopBtn.png (按钮)
- **尺寸**: 466rpx × 97rpx
- **格式**: PNG
- **用途**: 无时间弹窗的按钮图片
- **设计要求**: 透明背景，包含按钮文字和样式

## 图片命名规范

### 命名规则
- 使用 PascalCase 命名方式
- 包含组件类型和元素类型
- 版本号使用小写字母

### 命名示例
```
XingmaLabConfirmPopBg.png          # 确认弹窗背景
XingmaLabConfirmPopConfirmBtn.png  # 确认弹窗确认按钮
XingmaLabCancelBtn.png             # 确认弹窗取消按钮
XingmaLabNoTimePopBg.png           # 无时间弹窗背景
XingmaLabNoTimePopBtn.png          # 无时间弹窗按钮
```

## 版本管理

### 版本结构
```
XingmaLabPop/
├── v1/                           # 当前版本
│   ├── XingmaLabConfirmPopBg.png
│   ├── XingmaLabConfirmPopConfirmBtn.png
│   ├── XingmaLabCancelBtn.png
│   ├── XingmaLabNoTimePopBg.png
│   └── XingmaLabNoTimePopBtn.png
└── v2/                           # 未来版本（可选）
    └── ...
```

### 版本更新
1. 在 `xingmalabImages.js` 中修改 `version` 变量
2. 在 `static/XingmaLabPop/` 目录下创建新版本文件夹
3. 将新图片放入对应版本文件夹
4. 更新组件中的图片引用

## 图片优化建议

### 文件大小
- 单个图片文件大小控制在 100KB 以内
- 使用 PNG 格式保证透明背景效果
- 适当压缩图片，平衡质量和文件大小

### 设计规范
- 保持与整体 UI 风格一致
- 按钮图片包含合适的点击状态
- 背景图片支持不同屏幕尺寸适配

### 性能考虑
- 图片尺寸与显示尺寸保持一致
- 避免过大的图片文件影响加载速度
- 使用 `mode="aspectFit"` 确保图片正确显示

## 与 babyClass 组件的对比

### 相似点
1. **图片配置方式**: 都使用常量对象管理图片路径
2. **目录结构**: 都使用版本化的目录结构
3. **命名规范**: 都使用 PascalCase 命名方式
4. **格式要求**: 都使用 PNG 格式支持透明背景

### 不同点
1. **图片数量**: babyClass 有多个等级图片，xingmalab 只有弹窗图片
2. **图片用途**: babyClass 主要用于展示，xingmalab 主要用于交互
3. **图片尺寸**: babyClass 图片尺寸多样，xingmalab 图片尺寸相对固定

## 使用示例

### 在组件中使用
```vue
<template>
  <image 
    class="xingmalabconfirmpopbg" 
    :src="`${$baseUrl}${XINGMALAB_IMAGES.CONFIRM.BG}`" 
    mode="aspectFit"
  ></image>
</template>

<script setup>
import { XINGMALAB_IMAGES } from './xingmalabImages.js'
</script>
```

### 动态获取图片路径
```javascript
// 获取确认弹窗背景图片
const confirmBgPath = XINGMALAB_IMAGES.CONFIRM.BG

// 获取无时间弹窗按钮图片
const noTimeBtnPath = XINGMALAB_IMAGES.NO_TIME.BTN
```

## 注意事项

1. **路径一致性**: 确保 `xingmalabImages.js` 中的路径与实际文件路径一致
2. **版本同步**: 修改版本号时需要同步更新所有相关图片
3. **图片质量**: 确保图片清晰度满足不同设备显示需求
4. **文件格式**: 统一使用 PNG 格式，支持透明背景
5. **命名规范**: 严格遵循命名规范，便于维护和管理
6. **尺寸匹配**: 图片尺寸与 CSS 中定义的尺寸保持一致
7. **性能优化**: 合理控制图片文件大小，优化加载性能
8. **跨平台兼容**: 确保图片在不同平台上的显示效果一致

## 维护和更新

### 日常维护
- 定期检查图片文件是否存在
- 验证图片路径配置是否正确
- 监控图片加载性能

### 版本更新
- 记录版本更新日志
- 备份旧版本图片资源
- 测试新版本图片显示效果

### 问题排查
- 图片不显示：检查路径配置和文件存在性
- 图片变形：检查 CSS 尺寸设置
- 加载缓慢：优化图片文件大小和格式

## 弹窗布局结构

### 双层结构设计
弹窗组件采用双层结构设计，确保背景遮罩和弹窗内容正确显示：

```
弹窗容器 (100vw × 100vh)
├── 背景遮罩 (.mask)
│   ├── 位置: 覆盖整个屏幕
│   ├── 背景: rgba(0, 0, 0, 0.5) 半透明黑色
│   └── 层级: 基础层
└── 弹窗内容 (.popup-content)
    ├── 位置: 居中显示
    ├── 尺寸: 根据弹窗类型确定
    └── 层级: 内容层 (z-index: 1)
```

### 布局特点
1. **全屏覆盖**: 弹窗容器使用 `position: fixed` 和 `100vw × 100vh`
2. **居中显示**: 使用 `display: flex` 和 `align-items: center`, `justify-content: center`
3. **层级管理**: 遮罩层和内容层使用不同的 z-index 值
4. **响应式**: 支持不同屏幕尺寸的适配

### 弹窗类型尺寸

#### 确认弹窗
- **容器尺寸**: 100vw × 100vh (全屏)
- **内容尺寸**: 618rpx × 557rpx
- **背景图片**: 618rpx × 557rpx
- **确认按钮**: 275rpx × 97rpx (位置: left: 318rpx, top: 408rpx)
- **取消按钮**: 279rpx × 101rpx (位置: left: 28rpx, top: 406rpx)

#### 无时间弹窗
- **容器尺寸**: 100vw × 100vh (全屏)
- **内容尺寸**: 618rpx × 460rpx
- **背景图片**: 618rpx × 460rpx
- **按钮**: 466rpx × 97rpx (位置: left: 76rpx, top: 312rpx)
