import requestModule from './request.js';
const {
	api
} = requestModule;

/**
 * 获取用户信息
 * @returns
 */
export const fetchUserInfo = () => api.get('/c/user/memberInfo');

/**
 * 获取宝宝信息
 * @returns
 */
export const fetchBabyInfo = () => api.get('/c/user/babyInfo');
export const fetchBabyInfoById = (id) => api.get('/c/user/babyInfo', { id });
export const getGestationalWeeks = (dueDate) => api.get('/c/user/calGestationalWeeks', { dueDate });

/**
 * 根据wx.login接口返回的code完成登录
 * @param {*} code
 * @returns
 */
export const autoLoginByCode = (code) => api.get('/c/login/autologin', {
	code,
});

/**
 * 手机号授权，调用微信手机号快速验证组件，获取encryptedData、iv、code
 * 通过此接口完成手机号授权，注册新用户
 * @param {*} data : {phoneEncryptedData, phoneIv, code, codeLogin}
 * @returns
 */
export const fetchAutoPhone = (data) => api.post('/c/login/authPhone', data);

/**
 * 获取用户积分信息
 * @returns
 */
export const fetchMemberInfo = () => api.get('/c/user/memberInfo');

/* * 更新宝宝信息
 * @param {*} data
 * @returns
 */
export const updateBabyInfo = (data) => api.post('/c/user/saveBaby', data);

export const fetchUserJSON = () => api.get('/c/front/content',{type:'my'});