import requestModule from './request.js';
const {
    api
} = requestModule;

/**
 * 获取月礼包首页数据
 * @param {Object} params
 * @param {string} params.level - 用户等级 (diamond, starshine, starlight, gold, platinum)
 * @returns {Promise<Object>}
data:{
    batchCoupon:[
        {
            equityCouponInfoId:1,//权益优惠券信息ID	
            couponId:1,//优惠券ID	
            couponName:1,//优惠券名称	
            equityIcon:1,//权益图片	
            gradeAllow:true,//等级是否允许 true允许	
            startTime:1,//起始时间 2024-10-23 00:00:00	
            endTime:1,//结束时间 2024-10-23 00:00:00	
            stockUsage:1,//已使用库存数量	
            stockLimit:1,//可使用库存总数量	
            received:true,//是否已领取
            stockBatchList:[
                {
                    stockBatchId:1,//批次ID
                    startTime:1,//生效时间 例如：2024-10-28 23:00:00
                    status:1,//状态 0-待开始 1-抢券中 2-已结束		
                }
            ]
        }
    ],
    equityCouponList:[
        {
            equityCouponInfoId:1,//权益优惠券信息ID	    
            couponId:1,//优惠券ID	
            couponName:1,//优惠券名称	
            couponSystem:1,//优惠券系统 : BMP: 业务中台系统, SF : 顺丰 , CRM : CRM系统	
            equityIcon:1,//权益图片	
            receiveStatus:1,//优惠券状态 0-未领取 1-已领取	
            receiveTime:1,//领取时间
        }
    ]，
    next2810Countdown:0,//2810活动倒计时

}
 */
export const monthlyGiftIndex = () => api.get('/c/equity/monthlyGift/index')

/**
 * 月月礼-领取精选好券
 * @param {Object} data
 * @param {string} data.stockBatchId - 批次ID
 * @param {string} data.equityCouponInfoId - 权益优惠券信息ID
 * @returns {Promise<Object>}
 * {
 *   "success": true,
 *   "message": "领取成功",
 *   "data": {
 *     "couponId": "123",
 *     "couponName": "精选好券",
 *     "resourceId": "resource_123"
 * “receiveResult”：0，//领取结果 0-失败 1-成功	F
 *   }
 * }
 */
export const monthlyGiftDrawOne = (data) => api.post('/c/equity/monthlyGift/drawOne', {
    stockBatchId: data.stockBatchId,
    equityCouponInfoId: data.equityCouponInfoId
})

/**
 * 月月礼-领取限时1分购
 * @returns {Promise<Object>}
 * {
 *   "success": true,
 *   "message": "领取成功",
 *   "data": {
 *     "status": 1,
 *     "receivedNormalCouponList": [
 *       {
 *         "couponId": "123",
 *         "equityCouponInfoId": "456",
 *         "couponName": "限时1分购券",
 *         "equityIcon": "icon_url",
 *         "resourceId": "resource_789"
 *       }
 *     ]
 *   }
 * }
 */
export const monthlyGiftDrawAll = (data) => api.post('/c/equity/monthlyGift/drawAll', {

})



