import { defineStore } from "pinia";
import { getSigninAndTaskInfoJSON, checkInJSON, getSeckillList, getPointsBenefitCouponJSON, queryTodoResultJSON, getOriginInviteHomeJSON, assistInviteJSON } from "../api/integral";
import signinAndTaskInfoMock from '../mock/getSigninAndTaskInMock.json';
import checkInMock from '../mock/checkIndata.json';
import pointsBenefitCouponMock from '../mock/pointsBenefitCoupon.json';
import queryTodoResultMock from '../mock/queryTodoResult.json';
import originInviteHomeMock from '../mock/originInviteHome.json';
import assistInviteMock from '../mock/assistInvite.json';
export const useIntegralStore = defineStore("integral", {
  state: () => {
    return {
      _signinAndTaskInfo: null,
      _checkInData: null, // 新增：存储签到数据
      _seckillData: null, // 新增：存储秒杀数据
      _pointsBenefitCoupon: null, // 新增：存储积分权益券数据
      _queryTodoResult: null, // 新增：存储查询任务结果数据
      _originInviteHome: null, // 新增：存储邀请活动首页数据
      _assistInviteData: null, // 新增：存储邀请助力数据
    };
  },
  actions: {
    async getSigninAndTaskInfo(isdebug = false) {
        if(isdebug) {
            this._signinAndTaskInfo = signinAndTaskInfoMock;
            return signinAndTaskInfoMock;
        }else{
            const res = await getSigninAndTaskInfoJSON();
            this._signinAndTaskInfo = res;
            return res;
        }
    },
    async checkIn(activityId,isdebug = false) {
        // if(isdebug) {
        //     this._checkInData = checkInMock; // 存储到state中
        //     return checkInMock;
        // }else{
            const res = await checkInJSON(activityId);
            

            this._checkInData = res; // 存储到state中
            return res;
        // }
    },
    async getSeckillData(isdebug = false) {
        // if(isdebug) {
        //     // 使用模拟数据结构
        //     const mockSeckillData = {
        //         sessions: [
        //             {
        //                 id: 1,
        //                 status: 'ongoing',
        //                 countdown: '01:58:59',
        //                 timeTags: ['正在秒杀', '18:00开始', '20:00结束'],
        //                 goods: [
        //                     {
        //                         id: 'good1',
        //                         name: '商品名称商品名称商称商品名称商称商品名称商称商品名称商品...',
        //                         points: 100,
        //                         originalPoints: 500,
        //                         image: ''
        //                     }
        //                 ]
        //             }
        //         ]
        //     };
        //     this._seckillData = mockSeckillData;
        //     return mockSeckillData;
        // } else {
            const res = await getSeckillList();
            this._seckillData = res;
            return res;
        //   }
      },
    async getPointsBenefitCoupon(isdebug = false) {
        // if(isdebug) {
        //     this._pointsBenefitCoupon = pointsBenefitCouponMock;
        //     return pointsBenefitCouponMock;
        // }else{
            const res = await getPointsBenefitCouponJSON();
            this._pointsBenefitCoupon = res;
            return res;
        // }
    },
    async queryTodoResultServer(isdebug = false) {
        if(isdebug) {
            this._queryTodoResult = queryTodoResultMock;
            return queryTodoResultMock;
        }else{
            const res = await queryTodoResultJSON();
            this._queryTodoResult = res;
            return res;
        }
    },
    async getOriginInviteHome(isdebug = false) {
        if(isdebug) {
            this._originInviteHome = originInviteHomeMock;
            return originInviteHomeMock;
        }else{
            const res = await getOriginInviteHomeJSON();
            this._originInviteHome = res;
            return res;
        }
    },
    async assistInvite(invitationCode, wxUnionId, isdebug = false) {
        if(isdebug) {
            this._assistInviteData = assistInviteMock;
            return assistInviteMock;
        }else{
            const res = await assistInviteJSON(invitationCode, wxUnionId);
            this._assistInviteData = res;
            return res;
        }
    },
  },
  getters: {
    signinAndTaskInfo : (state) =>    {return state._signinAndTaskInfo;   },  
    checkInData : (state) =>    {return state._checkInData;   },
    seckillData : (state) =>    {return state._seckillData;   },
    pointsBenefitCoupon : (state) =>    {return state._pointsBenefitCoupon;   },
    queryTodoResult : (state) =>    {return state._queryTodoResult;   },
    originInviteHome : (state) =>    {return state._originInviteHome;   },
    assistInviteData : (state) =>    {return state._assistInviteData;   },
  },
});