import { defineStore } from "pinia";
import { JumpType } from "@/utils";
import { WHEEL_OPTIONS_YL, WHEEL_OPTIONS_YZ } from "@/cfg";

export const usePageCfgStore = defineStore("pageCfg", {
  state: () => {
    return {
      toolList: [
        {
          icon: "my/literature.png",
          title: "育儿百科",
          url: "https://secret.feihe.com/secret.html",
          jumpType: JumpType.H5,
        },
        {
          icon: "my/suyuan.png",
          title: "产品溯源",
          url: "",
          jumpType: JumpType.H5,
        },
        {
          icon: "my/book.png",
          title: "奶娃宝典",
          url: "",
          jumpType: JumpType.INNER,
        },
        {
          icon: "my/doctor.png",
          title: "医生问诊",
          url: "",
          jumpType: JumpType.MINI,
          checkRegister: true,
        },
        {
          icon: "my/babytest.png",
          title: "宝宝体质测试",
          url: "",
          jumpType: JumpType.H5,
        },
      ],

      conetntCfg: {
        wheelOptionsYL: WHEEL_OPTIONS_YL || [],
        wheelOptionsYZ: WHEEL_OPTIONS_YZ || [],
        contentLikeOptions: [
          "奶粉选择",
          "奶粉成分",
          "奶粉冲泡",
          "宝宝奶量",
          "生长发育",
          "常见疾病",
          "体检疫苗",
          "饮食营养补充",
          "辅食营养",
          "亲子关系",
          "早教游戏",
        ],
        productLikeOptions: [
          "飞鹤星飞帆",
          "星飞帆卓睿",
          "星飞帆卓耀",
          "星飞帆卓初",
          "星飞帆臻稚卓蓓",
          "星飞帆淳芮有机",
        ],
        specialAttentionOptions: ["过敏", "长肉", "肠道", "消化", "脑发育"],
        channelOptions: ["电商（京东/天猫）", "母婴店"],
      },
    };
  },
  actions: {
    /**
     * 设置用户cuk
     * @param {Object} cuk
     */
    setCuk(cuk) {
      this.cuk = cuk;
      uni.setStorageSync("cuk", cuk);
    },
  },
});
