"use strict";
const common_vendor = require("../common/vendor.js");
const _sfc_main = {
  __name: "TabBar",
  props: {
    tabList: {
      type: Array,
      default: () => [
        {
          text: "首页",
          iconPath: "/static/tabBar/icon_tab_home_normal.png",
          selectedIconPath: "/static/tabBar/icon_tab_home_selected.png"
        },
        {
          text: "品牌故事",
          iconPath: "/static/tabBar/icon_tab_brand_normal.png",
          selectedIconPath: "/static/tabBar/icon_tab_brand_selected.png"
        },
        {
          text: "积分服务",
          iconPath: "/static/tabBar/icon_tab_gift_normal.png",
          selectedIconPath: "/static/tabBar/icon_tab_gift_selected.png"
        },
        {
          text: "我的",
          iconPath: "/static/tabBar/icon_tab_person_normal.png",
          selectedIconPath: "/static/tabBar/icon_tab_person_selected.png"
        }
      ]
    }
  },
  emits: ["tabClick"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const currentIndex = common_vendor.ref(0);
    const handleTabClick = (index, item) => {
      currentIndex.value = index;
      emit("tabClick", { index, item });
    };
    return (_ctx, _cache) => {
      return {
        a: common_vendor.f(__props.tabList, (item, index, i0) => {
          return {
            a: currentIndex.value === index ? item.selectedIconPath : item.iconPath,
            b: common_vendor.n(`tab-icon tab-icon-${index}`),
            c: common_vendor.t(item.text),
            d: currentIndex.value === index ? 1 : "",
            e: index,
            f: currentIndex.value === index ? 1 : "",
            g: common_vendor.o(($event) => handleTabClick(index, item), index)
          };
        })
      };
    };
  }
};
const Component = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["__scopeId", "data-v-89ca1f91"]]);
wx.createComponent(Component);
//# sourceMappingURL=../../.sourcemap/mp-weixin/components/TabBar.js.map
