/*
 * @Author: lijiahui jiahui.li@eb.manpower.com.cn
 * @Date: 2025-10-14 09:00:31
 * @LastEditors: lijiahui jiahui.li@eb.manpower.com.cn
 * @LastEditTime: 2025-10-15 14:29:05
 * @FilePath: \activity-platform-webd:\gongzuo\momclub-front\subPackages\xmhAactivity\utils\common.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

/**
* 解码URI编码的对象或字符串
* @param obj 一个键值对对象，其中值为URI编码的字符串
* @returns 如果输入的是对象，则返回一个新对象，其中每个值都经过URI解码；如果输入的是字符串，则直接返回经过URI解码的字符串。
*/
export function decode(obj) {
  let decodeObj = {}
  // 如果obj是对象类型，则逐个解码对象中的每个值
  if (obj && typeof obj === "object") {
    for (var i in obj) {
      decodeObj[i] = decodeURIComponent(obj[i])
    }
  } else {
    // 如果obj不是对象类型，则直接对其进行URI解码
    decodeObj = decodeURIComponent(obj)
  }
  return decodeObj
}

/**
 * 获取当前页面的参数
 * 该函数没有参数
 * @returns {Object} 返回解码后的参数对象
 */
export function getParams() {
	// 获取当前加载的页面列表
	const pages = getCurrentPages()
	// 获取当前页面对象
	const currentPage = pages[pages.length - 1]
	// 获取当前页面的选项参数，可用于获取URL中的参数
	const options = currentPage.options
	// 解析并获取传入的scene参数
	const {
		scene
	} = options
	// 检查scene参数是否存在
	if (scene) {
		// 对scene参数进行解码
		const tempScene = decode(scene)
		// 检查scene参数是否包含'='，即是否为键值对形式
		if (tempScene.indexOf('=') >= 0) {
			// 将scene参数按'&'分割为键值对数组
			const arr = tempScene.split('&')
			// 遍历数组，将键值对形式的参数添加到options对象中
			arr.map((item) => {
				if (item) {
					const i = item.split('=')
					options[i[0]] = i[1]
				}
			})
			// 删除原始的scene参数
			delete options.scene
		}
	}
	// 返回解码后的options对象
	return decode(options)
}

// 获取CDN地址
export const getCdnUrl = (env) => {
  let cdnUrl = ''
  if (env === 'prod') {
    cdnUrl = 'http://xmyx-lbs-image.oss-cn-beijing.aliyuncs.com/xmyx/xmh/prod/'
  } else {
    cdnUrl = 'http://xmyx-lbs-image.oss-cn-beijing.aliyuncs.com/xmyx/xmh/uat/'
  }
  return cdnUrl
}

// 判断是不是刘海屏手机
export const isIphone = () => {
  const sysinfo = wx.getDeviceInfo()
  // 获取小程序启动时的参数     
var launchOptions = wx.getLaunchOptionsSync();
  if(launchOptions.scene==1154){//单页模式  sysinfo找不到
    return false
  }
  const { screenHeight } = wx.getWindowInfo();
  if (sysinfo.system.indexOf("iOS") !== -1 && (screenHeight > 736)) {
    return true
  } else {
    return false
  }
}
