export enum JumpType {
	INNER = 1, // 内部小程序页面跳转
	MINI = 2, // 其他小程序页面跳转
	H5 = 3, // https 网络连接跳转
}

export interface LinkType {
	type: JumpType
	url: string
	extra?: Record<string, any>
}

export interface MdConfig {
	pageName: string
	componentName: string
	componentContent: string
	logExposure?: boolean
	logClick?: boolean
}

export interface CodeResponse<T> {
	code: number
	message: string
	data: T
	success: boolean
	ok: boolean
}

export interface ComponentType {
	name: string
	props: Record<string, any>
	styles: Record<string, any>
}

export interface ThematicPageType{
	content: string
}

export interface PageConfig {
	title: string
	shareConfig: {
		title: string
		imageUrl: string
	}
	components: ComponentType[]
	styles: Record<string, any>
}
