import {useGlobalStore} from "@/stores/global";

const version = 'v1'

export function getCdnUrl(path){
	const {baseUrl} = useGlobalStore()
	return `${baseUrl}activity/1015/${version}/${path}`
}

function normalizeDateInput(dateInput: any): Date {
	if (dateInput instanceof Date) {
		return dateInput;
	}

	if (typeof dateInput === 'string') {
		// 处理 "yyyy-MM-dd HH:mm:ss" 格式
		if (dateInput.includes(' ') && dateInput.includes('-')) {
			return new Date(dateInput.replace(' ', 'T'));
		}
		// 其他情况直接尝试创建Date对象
		return new Date(dateInput);
	}

	return new Date(dateInput);
}

export function getDetailedHumanizedTimeDiff(targetTime: any) {
	const nowTimestamp = Date.now();
	const targetDate = normalizeDateInput(targetTime ?? nowTimestamp);

	if (isNaN(targetDate.getTime())) {
		debugger
		console.warn('Invalid date input:', targetTime);
		return '无效时间';
	}

	const targetTimestamp = targetDate.getTime();
	const diff = nowTimestamp - targetTimestamp;
	const isPast = diff > 0;
	const absDiff = Math.abs(diff);

	let result = '';

	if (absDiff < 60 * 1000) {
		// 小于1分钟
		result = '刚刚';
	} else if (absDiff < 60 * 60 * 1000) {
		// 小于1小时
		const minutes = Math.floor(absDiff / (60 * 1000));
		result = isPast ? `${minutes}分钟前` : `${minutes}分钟后`;
	} else if (absDiff < 24 * 60 * 60 * 1000) {
		// 小于1天
		const hours = Math.floor(absDiff / (60 * 60 * 1000));
		result = isPast ? `${hours}小时前` : `${hours}小时后`;
	} else if (absDiff < 30 * 24 * 60 * 60 * 1000) {
		// 小于30天
		const days = Math.floor(absDiff / (24 * 60 * 60 * 1000));
		result = isPast ? `${days}天前` : `${days}天后`;
	} else if (absDiff < 12 * 30 * 24 * 60 * 60 * 1000) {
		// 小于12个月
		const months = Math.floor(absDiff / (30 * 24 * 60 * 60 * 1000));
		result = isPast ? `${months}个月前` : `${months}个月后`;
	} else {
		// 超过12个月
		const years = Math.floor(absDiff / (12 * 30 * 24 * 60 * 60 * 1000));
		result = isPast ? `${years}年前` : `${years}年后`;
	}

	return result;
}

